package ros

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResourceTypes invokes the ros.DescribeResourceTypes API synchronously
// api document: https://help.aliyun.com/api/ros/describeresourcetypes.html
func (client *Client) DescribeResourceTypes(request *DescribeResourceTypesRequest) (response *DescribeResourceTypesResponse, err error) {
	response = CreateDescribeResourceTypesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResourceTypesWithChan invokes the ros.DescribeResourceTypes API asynchronously
// api document: https://help.aliyun.com/api/ros/describeresourcetypes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResourceTypesWithChan(request *DescribeResourceTypesRequest) (<-chan *DescribeResourceTypesResponse, <-chan error) {
	responseChan := make(chan *DescribeResourceTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResourceTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResourceTypesWithCallback invokes the ros.DescribeResourceTypes API asynchronously
// api document: https://help.aliyun.com/api/ros/describeresourcetypes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResourceTypesWithCallback(request *DescribeResourceTypesRequest, callback func(response *DescribeResourceTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResourceTypesResponse
		var err error
		defer close(result)
		response, err = client.DescribeResourceTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResourceTypesRequest is the request struct for api DescribeResourceTypes
type DescribeResourceTypesRequest struct {
	*requests.RoaRequest
	SupportStatus string `position:"Query" name:"SupportStatus"`
}

// DescribeResourceTypesResponse is the response struct for api DescribeResourceTypes
type DescribeResourceTypesResponse struct {
	*responses.BaseResponse
}

// CreateDescribeResourceTypesRequest creates a request to invoke DescribeResourceTypes API
func CreateDescribeResourceTypesRequest() (request *DescribeResourceTypesRequest) {
	request = &DescribeResourceTypesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ROS", "2015-09-01", "DescribeResourceTypes", "/resource_types", "ROS", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeResourceTypesResponse creates a response to parse from DescribeResourceTypes response
func CreateDescribeResourceTypesResponse() (response *DescribeResourceTypesResponse) {
	response = &DescribeResourceTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
