package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourceGroupListAclMode invokes the resourcemanager.GetResourceGroupListAclMode API synchronously
func (client *Client) GetResourceGroupListAclMode(request *GetResourceGroupListAclModeRequest) (response *GetResourceGroupListAclModeResponse, err error) {
	response = CreateGetResourceGroupListAclModeResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourceGroupListAclModeWithChan invokes the resourcemanager.GetResourceGroupListAclMode API asynchronously
func (client *Client) GetResourceGroupListAclModeWithChan(request *GetResourceGroupListAclModeRequest) (<-chan *GetResourceGroupListAclModeResponse, <-chan error) {
	responseChan := make(chan *GetResourceGroupListAclModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourceGroupListAclMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourceGroupListAclModeWithCallback invokes the resourcemanager.GetResourceGroupListAclMode API asynchronously
func (client *Client) GetResourceGroupListAclModeWithCallback(request *GetResourceGroupListAclModeRequest, callback func(response *GetResourceGroupListAclModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourceGroupListAclModeResponse
		var err error
		defer close(result)
		response, err = client.GetResourceGroupListAclMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourceGroupListAclModeRequest is the request struct for api GetResourceGroupListAclMode
type GetResourceGroupListAclModeRequest struct {
	*requests.RpcRequest
}

// GetResourceGroupListAclModeResponse is the response struct for api GetResourceGroupListAclMode
type GetResourceGroupListAclModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Mode      string `json:"Mode" xml:"Mode"`
}

// CreateGetResourceGroupListAclModeRequest creates a request to invoke GetResourceGroupListAclMode API
func CreateGetResourceGroupListAclModeRequest() (request *GetResourceGroupListAclModeRequest) {
	request = &GetResourceGroupListAclModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetResourceGroupListAclMode", "", "")
	request.Method = requests.GET
	return
}

// CreateGetResourceGroupListAclModeResponse creates a response to parse from GetResourceGroupListAclMode response
func CreateGetResourceGroupListAclModeResponse() (response *GetResourceGroupListAclModeResponse) {
	response = &GetResourceGroupListAclModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
