package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNodeSpec invokes the r_kvstore.ModifyNodeSpec API synchronously
func (client *Client) ModifyNodeSpec(request *ModifyNodeSpecRequest) (response *ModifyNodeSpecResponse, err error) {
	response = CreateModifyNodeSpecResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNodeSpecWithChan invokes the r_kvstore.ModifyNodeSpec API asynchronously
func (client *Client) ModifyNodeSpecWithChan(request *ModifyNodeSpecRequest) (<-chan *ModifyNodeSpecResponse, <-chan error) {
	responseChan := make(chan *ModifyNodeSpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNodeSpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNodeSpecWithCallback invokes the r_kvstore.ModifyNodeSpec API asynchronously
func (client *Client) ModifyNodeSpecWithCallback(request *ModifyNodeSpecRequest, callback func(response *ModifyNodeSpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNodeSpecResponse
		var err error
		defer close(result)
		response, err = client.ModifyNodeSpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNodeSpecRequest is the request struct for api ModifyNodeSpec
type ModifyNodeSpecRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CouponNo             string           `position:"Query" name:"CouponNo"`
	InstanceClass        string           `position:"Query" name:"InstanceClass"`
	SwitchTimeMode       string           `position:"Query" name:"SwitchTimeMode"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	NodeId               string           `position:"Query" name:"NodeId"`
	BusinessInfo         string           `position:"Query" name:"BusinessInfo"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	OrderType            string           `position:"Query" name:"OrderType"`
}

// ModifyNodeSpecResponse is the response struct for api ModifyNodeSpec
type ModifyNodeSpecResponse struct {
	*responses.BaseResponse
	OrderId   int64  `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNodeSpecRequest creates a request to invoke ModifyNodeSpec API
func CreateModifyNodeSpecRequest() (request *ModifyNodeSpecRequest) {
	request = &ModifyNodeSpecRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyNodeSpec", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNodeSpecResponse creates a response to parse from ModifyNodeSpec response
func CreateModifyNodeSpecResponse() (response *ModifyNodeSpecResponse) {
	response = &ModifyNodeSpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
