package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchAddFeishuUsers invokes the quickbi_public.BatchAddFeishuUsers API synchronously
func (client *Client) BatchAddFeishuUsers(request *BatchAddFeishuUsersRequest) (response *BatchAddFeishuUsersResponse, err error) {
	response = CreateBatchAddFeishuUsersResponse()
	err = client.DoAction(request, response)
	return
}

// BatchAddFeishuUsersWithChan invokes the quickbi_public.BatchAddFeishuUsers API asynchronously
func (client *Client) BatchAddFeishuUsersWithChan(request *BatchAddFeishuUsersRequest) (<-chan *BatchAddFeishuUsersResponse, <-chan error) {
	responseChan := make(chan *BatchAddFeishuUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchAddFeishuUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchAddFeishuUsersWithCallback invokes the quickbi_public.BatchAddFeishuUsers API asynchronously
func (client *Client) BatchAddFeishuUsersWithCallback(request *BatchAddFeishuUsersRequest, callback func(response *BatchAddFeishuUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchAddFeishuUsersResponse
		var err error
		defer close(result)
		response, err = client.BatchAddFeishuUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchAddFeishuUsersRequest is the request struct for api BatchAddFeishuUsers
type BatchAddFeishuUsersRequest struct {
	*requests.RpcRequest
	IsAdmin      requests.Boolean `position:"Query" name:"IsAdmin"`
	FeishuUsers  string           `position:"Query" name:"FeishuUsers"`
	AccessPoint  string           `position:"Query" name:"AccessPoint"`
	UserType     requests.Integer `position:"Query" name:"UserType"`
	SignType     string           `position:"Query" name:"SignType"`
	UserGroupIds string           `position:"Query" name:"UserGroupIds"`
	IsAuthAdmin  requests.Boolean `position:"Query" name:"IsAuthAdmin"`
}

// BatchAddFeishuUsersResponse is the response struct for api BatchAddFeishuUsers
type BatchAddFeishuUsersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateBatchAddFeishuUsersRequest creates a request to invoke BatchAddFeishuUsers API
func CreateBatchAddFeishuUsersRequest() (request *BatchAddFeishuUsersRequest) {
	request = &BatchAddFeishuUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "BatchAddFeishuUsers", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchAddFeishuUsersResponse creates a response to parse from BatchAddFeishuUsers response
func CreateBatchAddFeishuUsersResponse() (response *BatchAddFeishuUsersResponse) {
	response = &BatchAddFeishuUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
