package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBClusterEndpoint invokes the polardb.ModifyDBClusterEndpoint API synchronously
func (client *Client) ModifyDBClusterEndpoint(request *ModifyDBClusterEndpointRequest) (response *ModifyDBClusterEndpointResponse, err error) {
	response = CreateModifyDBClusterEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBClusterEndpointWithChan invokes the polardb.ModifyDBClusterEndpoint API asynchronously
func (client *Client) ModifyDBClusterEndpointWithChan(request *ModifyDBClusterEndpointRequest) (<-chan *ModifyDBClusterEndpointResponse, <-chan error) {
	responseChan := make(chan *ModifyDBClusterEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBClusterEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBClusterEndpointWithCallback invokes the polardb.ModifyDBClusterEndpoint API asynchronously
func (client *Client) ModifyDBClusterEndpointWithCallback(request *ModifyDBClusterEndpointRequest, callback func(response *ModifyDBClusterEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBClusterEndpointResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBClusterEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBClusterEndpointRequest is the request struct for api ModifyDBClusterEndpoint
type ModifyDBClusterEndpointRequest struct {
	*requests.RpcRequest
	AutoAddNewNodes       string           `position:"Query" name:"AutoAddNewNodes"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBEndpointId          string           `position:"Query" name:"DBEndpointId"`
	ReadWriteMode         string           `position:"Query" name:"ReadWriteMode"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId           string           `position:"Query" name:"DBClusterId"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	EndpointConfig        string           `position:"Query" name:"EndpointConfig"`
	DBEndpointDescription string           `position:"Query" name:"DBEndpointDescription"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	Nodes                 string           `position:"Query" name:"Nodes"`
}

// ModifyDBClusterEndpointResponse is the response struct for api ModifyDBClusterEndpoint
type ModifyDBClusterEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBClusterEndpointRequest creates a request to invoke ModifyDBClusterEndpoint API
func CreateModifyDBClusterEndpointRequest() (request *ModifyDBClusterEndpointRequest) {
	request = &ModifyDBClusterEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ModifyDBClusterEndpoint", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBClusterEndpointResponse creates a response to parse from ModifyDBClusterEndpoint response
func CreateModifyDBClusterEndpointResponse() (response *ModifyDBClusterEndpointResponse) {
	response = &ModifyDBClusterEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
