package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNumberDistrictInfoParsingTask invokes the outboundbot.CreateNumberDistrictInfoParsingTask API synchronously
func (client *Client) CreateNumberDistrictInfoParsingTask(request *CreateNumberDistrictInfoParsingTaskRequest) (response *CreateNumberDistrictInfoParsingTaskResponse, err error) {
	response = CreateCreateNumberDistrictInfoParsingTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNumberDistrictInfoParsingTaskWithChan invokes the outboundbot.CreateNumberDistrictInfoParsingTask API asynchronously
func (client *Client) CreateNumberDistrictInfoParsingTaskWithChan(request *CreateNumberDistrictInfoParsingTaskRequest) (<-chan *CreateNumberDistrictInfoParsingTaskResponse, <-chan error) {
	responseChan := make(chan *CreateNumberDistrictInfoParsingTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNumberDistrictInfoParsingTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNumberDistrictInfoParsingTaskWithCallback invokes the outboundbot.CreateNumberDistrictInfoParsingTask API asynchronously
func (client *Client) CreateNumberDistrictInfoParsingTaskWithCallback(request *CreateNumberDistrictInfoParsingTaskRequest, callback func(response *CreateNumberDistrictInfoParsingTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNumberDistrictInfoParsingTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateNumberDistrictInfoParsingTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNumberDistrictInfoParsingTaskRequest is the request struct for api CreateNumberDistrictInfoParsingTask
type CreateNumberDistrictInfoParsingTaskRequest struct {
	*requests.RpcRequest
	FileSize requests.Integer `position:"Query" name:"FileSize"`
	FilePath string           `position:"Query" name:"FilePath"`
}

// CreateNumberDistrictInfoParsingTaskResponse is the response struct for api CreateNumberDistrictInfoParsingTask
type CreateNumberDistrictInfoParsingTaskResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateCreateNumberDistrictInfoParsingTaskRequest creates a request to invoke CreateNumberDistrictInfoParsingTask API
func CreateCreateNumberDistrictInfoParsingTaskRequest() (request *CreateNumberDistrictInfoParsingTaskRequest) {
	request = &CreateNumberDistrictInfoParsingTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "CreateNumberDistrictInfoParsingTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateNumberDistrictInfoParsingTaskResponse creates a response to parse from CreateNumberDistrictInfoParsingTask response
func CreateCreateNumberDistrictInfoParsingTaskResponse() (response *CreateNumberDistrictInfoParsingTaskResponse) {
	response = &CreateNumberDistrictInfoParsingTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
