package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyNumberDistrictInfoParsingResult invokes the outboundbot.ApplyNumberDistrictInfoParsingResult API synchronously
func (client *Client) ApplyNumberDistrictInfoParsingResult(request *ApplyNumberDistrictInfoParsingResultRequest) (response *ApplyNumberDistrictInfoParsingResultResponse, err error) {
	response = CreateApplyNumberDistrictInfoParsingResultResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyNumberDistrictInfoParsingResultWithChan invokes the outboundbot.ApplyNumberDistrictInfoParsingResult API asynchronously
func (client *Client) ApplyNumberDistrictInfoParsingResultWithChan(request *ApplyNumberDistrictInfoParsingResultRequest) (<-chan *ApplyNumberDistrictInfoParsingResultResponse, <-chan error) {
	responseChan := make(chan *ApplyNumberDistrictInfoParsingResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyNumberDistrictInfoParsingResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyNumberDistrictInfoParsingResultWithCallback invokes the outboundbot.ApplyNumberDistrictInfoParsingResult API asynchronously
func (client *Client) ApplyNumberDistrictInfoParsingResultWithCallback(request *ApplyNumberDistrictInfoParsingResultRequest, callback func(response *ApplyNumberDistrictInfoParsingResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyNumberDistrictInfoParsingResultResponse
		var err error
		defer close(result)
		response, err = client.ApplyNumberDistrictInfoParsingResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyNumberDistrictInfoParsingResultRequest is the request struct for api ApplyNumberDistrictInfoParsingResult
type ApplyNumberDistrictInfoParsingResultRequest struct {
	*requests.RpcRequest
	VersionId string `position:"Query" name:"VersionId"`
}

// ApplyNumberDistrictInfoParsingResultResponse is the response struct for api ApplyNumberDistrictInfoParsingResult
type ApplyNumberDistrictInfoParsingResultResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateApplyNumberDistrictInfoParsingResultRequest creates a request to invoke ApplyNumberDistrictInfoParsingResult API
func CreateApplyNumberDistrictInfoParsingResultRequest() (request *ApplyNumberDistrictInfoParsingResultRequest) {
	request = &ApplyNumberDistrictInfoParsingResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ApplyNumberDistrictInfoParsingResult", "", "")
	request.Method = requests.POST
	return
}

// CreateApplyNumberDistrictInfoParsingResultResponse creates a response to parse from ApplyNumberDistrictInfoParsingResult response
func CreateApplyNumberDistrictInfoParsingResultResponse() (response *ApplyNumberDistrictInfoParsingResultResponse) {
	response = &ApplyNumberDistrictInfoParsingResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
