package onsmqtt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGroupId invokes the onsmqtt.ListGroupId API synchronously
func (client *Client) ListGroupId(request *ListGroupIdRequest) (response *ListGroupIdResponse, err error) {
	response = CreateListGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// ListGroupIdWithChan invokes the onsmqtt.ListGroupId API asynchronously
func (client *Client) ListGroupIdWithChan(request *ListGroupIdRequest) (<-chan *ListGroupIdResponse, <-chan error) {
	responseChan := make(chan *ListGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGroupIdWithCallback invokes the onsmqtt.ListGroupId API asynchronously
func (client *Client) ListGroupIdWithCallback(request *ListGroupIdRequest, callback func(response *ListGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGroupIdResponse
		var err error
		defer close(result)
		response, err = client.ListGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGroupIdRequest is the request struct for api ListGroupId
type ListGroupIdRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListGroupIdResponse is the response struct for api ListGroupId
type ListGroupIdResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Data      []MqttGroupIdDo `json:"Data" xml:"Data"`
}

// CreateListGroupIdRequest creates a request to invoke ListGroupId API
func CreateListGroupIdRequest() (request *ListGroupIdRequest) {
	request = &ListGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OnsMqtt", "2020-04-20", "ListGroupId", "onsmqtt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGroupIdResponse creates a response to parse from ListGroupId response
func CreateListGroupIdResponse() (response *ListGroupIdResponse) {
	response = &ListGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
