package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTenants invokes the oceanbasepro.DeleteTenants API synchronously
func (client *Client) DeleteTenants(request *DeleteTenantsRequest) (response *DeleteTenantsResponse, err error) {
	response = CreateDeleteTenantsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTenantsWithChan invokes the oceanbasepro.DeleteTenants API asynchronously
func (client *Client) DeleteTenantsWithChan(request *DeleteTenantsRequest) (<-chan *DeleteTenantsResponse, <-chan error) {
	responseChan := make(chan *DeleteTenantsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTenants(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTenantsWithCallback invokes the oceanbasepro.DeleteTenants API asynchronously
func (client *Client) DeleteTenantsWithCallback(request *DeleteTenantsRequest, callback func(response *DeleteTenantsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTenantsResponse
		var err error
		defer close(result)
		response, err = client.DeleteTenants(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTenantsRequest is the request struct for api DeleteTenants
type DeleteTenantsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantIds  string `position:"Body" name:"TenantIds"`
}

// DeleteTenantsResponse is the response struct for api DeleteTenants
type DeleteTenantsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	TenantIds []string `json:"TenantIds" xml:"TenantIds"`
}

// CreateDeleteTenantsRequest creates a request to invoke DeleteTenants API
func CreateDeleteTenantsRequest() (request *DeleteTenantsRequest) {
	request = &DeleteTenantsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DeleteTenants", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTenantsResponse creates a response to parse from DeleteTenants response
func CreateDeleteTenantsResponse() (response *DeleteTenantsResponse) {
	response = &DeleteTenantsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
