package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunPreTrainService invokes the nlp_automl.RunPreTrainService API synchronously
func (client *Client) RunPreTrainService(request *RunPreTrainServiceRequest) (response *RunPreTrainServiceResponse, err error) {
	response = CreateRunPreTrainServiceResponse()
	err = client.DoAction(request, response)
	return
}

// RunPreTrainServiceWithChan invokes the nlp_automl.RunPreTrainService API asynchronously
func (client *Client) RunPreTrainServiceWithChan(request *RunPreTrainServiceRequest) (<-chan *RunPreTrainServiceResponse, <-chan error) {
	responseChan := make(chan *RunPreTrainServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunPreTrainService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunPreTrainServiceWithCallback invokes the nlp_automl.RunPreTrainService API asynchronously
func (client *Client) RunPreTrainServiceWithCallback(request *RunPreTrainServiceRequest, callback func(response *RunPreTrainServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunPreTrainServiceResponse
		var err error
		defer close(result)
		response, err = client.RunPreTrainService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunPreTrainServiceRequest is the request struct for api RunPreTrainService
type RunPreTrainServiceRequest struct {
	*requests.RpcRequest
	Product        string `position:"Body" name:"Product"`
	PredictContent string `position:"Body" name:"PredictContent"`
	ServiceVersion string `position:"Body" name:"ServiceVersion"`
	ServiceName    string `position:"Body" name:"ServiceName"`
}

// RunPreTrainServiceResponse is the response struct for api RunPreTrainService
type RunPreTrainServiceResponse struct {
	*responses.BaseResponse
	PredictResult string `json:"PredictResult" xml:"PredictResult"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateRunPreTrainServiceRequest creates a request to invoke RunPreTrainService API
func CreateRunPreTrainServiceRequest() (request *RunPreTrainServiceRequest) {
	request = &RunPreTrainServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-11-11", "RunPreTrainService", "", "")
	request.Method = requests.POST
	return
}

// CreateRunPreTrainServiceResponse creates a response to parse from RunPreTrainService response
func CreateRunPreTrainServiceResponse() (response *RunPreTrainServiceResponse) {
	response = &RunPreTrainServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
