package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMountedClients invokes the nas.DescribeMountedClients API synchronously
func (client *Client) DescribeMountedClients(request *DescribeMountedClientsRequest) (response *DescribeMountedClientsResponse, err error) {
	response = CreateDescribeMountedClientsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMountedClientsWithChan invokes the nas.DescribeMountedClients API asynchronously
func (client *Client) DescribeMountedClientsWithChan(request *DescribeMountedClientsRequest) (<-chan *DescribeMountedClientsResponse, <-chan error) {
	responseChan := make(chan *DescribeMountedClientsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMountedClients(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMountedClientsWithCallback invokes the nas.DescribeMountedClients API asynchronously
func (client *Client) DescribeMountedClientsWithCallback(request *DescribeMountedClientsRequest, callback func(response *DescribeMountedClientsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMountedClientsResponse
		var err error
		defer close(result)
		response, err = client.DescribeMountedClients(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMountedClientsRequest is the request struct for api DescribeMountedClients
type DescribeMountedClientsRequest struct {
	*requests.RpcRequest
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	ClientIP          string           `position:"Query" name:"ClientIP"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	FileSystemId      string           `position:"Query" name:"FileSystemId"`
	MountTargetDomain string           `position:"Query" name:"MountTargetDomain"`
}

// DescribeMountedClientsResponse is the response struct for api DescribeMountedClients
type DescribeMountedClientsResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	Clients    Clients `json:"Clients" xml:"Clients"`
}

// CreateDescribeMountedClientsRequest creates a request to invoke DescribeMountedClients API
func CreateDescribeMountedClientsRequest() (request *DescribeMountedClientsRequest) {
	request = &DescribeMountedClientsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DescribeMountedClients", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMountedClientsResponse creates a response to parse from DescribeMountedClients response
func CreateDescribeMountedClientsResponse() (response *DescribeMountedClientsResponse) {
	response = &DescribeMountedClientsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
