package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMcubeNebulaTaskDetail invokes the mpaas.GetMcubeNebulaTaskDetail API synchronously
func (client *Client) GetMcubeNebulaTaskDetail(request *GetMcubeNebulaTaskDetailRequest) (response *GetMcubeNebulaTaskDetailResponse, err error) {
	response = CreateGetMcubeNebulaTaskDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetMcubeNebulaTaskDetailWithChan invokes the mpaas.GetMcubeNebulaTaskDetail API asynchronously
func (client *Client) GetMcubeNebulaTaskDetailWithChan(request *GetMcubeNebulaTaskDetailRequest) (<-chan *GetMcubeNebulaTaskDetailResponse, <-chan error) {
	responseChan := make(chan *GetMcubeNebulaTaskDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMcubeNebulaTaskDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMcubeNebulaTaskDetailWithCallback invokes the mpaas.GetMcubeNebulaTaskDetail API asynchronously
func (client *Client) GetMcubeNebulaTaskDetailWithCallback(request *GetMcubeNebulaTaskDetailRequest, callback func(response *GetMcubeNebulaTaskDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMcubeNebulaTaskDetailResponse
		var err error
		defer close(result)
		response, err = client.GetMcubeNebulaTaskDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMcubeNebulaTaskDetailRequest is the request struct for api GetMcubeNebulaTaskDetail
type GetMcubeNebulaTaskDetailRequest struct {
	*requests.RpcRequest
	TenantId    string           `position:"Body" name:"TenantId"`
	TaskId      requests.Integer `position:"Body" name:"TaskId"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// GetMcubeNebulaTaskDetailResponse is the response struct for api GetMcubeNebulaTaskDetail
type GetMcubeNebulaTaskDetailResponse struct {
	*responses.BaseResponse
	ResultMessage                  string                         `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                     string                         `json:"ResultCode" xml:"ResultCode"`
	RequestId                      string                         `json:"RequestId" xml:"RequestId"`
	GetMcubeNebulaTaskDetailResult GetMcubeNebulaTaskDetailResult `json:"GetMcubeNebulaTaskDetailResult" xml:"GetMcubeNebulaTaskDetailResult"`
}

// CreateGetMcubeNebulaTaskDetailRequest creates a request to invoke GetMcubeNebulaTaskDetail API
func CreateGetMcubeNebulaTaskDetailRequest() (request *GetMcubeNebulaTaskDetailRequest) {
	request = &GetMcubeNebulaTaskDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetMcubeNebulaTaskDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMcubeNebulaTaskDetailResponse creates a response to parse from GetMcubeNebulaTaskDetail response
func CreateGetMcubeNebulaTaskDetailResponse() (response *GetMcubeNebulaTaskDetailResponse) {
	response = &GetMcubeNebulaTaskDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
