package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportMappCenterAppConfig invokes the mpaas.ExportMappCenterAppConfig API synchronously
func (client *Client) ExportMappCenterAppConfig(request *ExportMappCenterAppConfigRequest) (response *ExportMappCenterAppConfigResponse, err error) {
	response = CreateExportMappCenterAppConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ExportMappCenterAppConfigWithChan invokes the mpaas.ExportMappCenterAppConfig API asynchronously
func (client *Client) ExportMappCenterAppConfigWithChan(request *ExportMappCenterAppConfigRequest) (<-chan *ExportMappCenterAppConfigResponse, <-chan error) {
	responseChan := make(chan *ExportMappCenterAppConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportMappCenterAppConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportMappCenterAppConfigWithCallback invokes the mpaas.ExportMappCenterAppConfig API asynchronously
func (client *Client) ExportMappCenterAppConfigWithCallback(request *ExportMappCenterAppConfigRequest, callback func(response *ExportMappCenterAppConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportMappCenterAppConfigResponse
		var err error
		defer close(result)
		response, err = client.ExportMappCenterAppConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportMappCenterAppConfigRequest is the request struct for api ExportMappCenterAppConfig
type ExportMappCenterAppConfigRequest struct {
	*requests.RpcRequest
	SystemType    string           `position:"Body" name:"SystemType"`
	OnexFlag      requests.Boolean `position:"Body" name:"OnexFlag"`
	Identifier    string           `position:"Body" name:"Identifier"`
	CertRsaBase64 string           `position:"Body" name:"CertRsaBase64"`
	AppId         string           `position:"Body" name:"AppId"`
	WorkspaceId   string           `position:"Body" name:"WorkspaceId"`
}

// ExportMappCenterAppConfigResponse is the response struct for api ExportMappCenterAppConfig
type ExportMappCenterAppConfigResponse struct {
	*responses.BaseResponse
	ResultMessage                   string                          `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                      string                          `json:"ResultCode" xml:"ResultCode"`
	RequestId                       string                          `json:"RequestId" xml:"RequestId"`
	ExportMappCenterAppConfigResult ExportMappCenterAppConfigResult `json:"ExportMappCenterAppConfigResult" xml:"ExportMappCenterAppConfigResult"`
}

// CreateExportMappCenterAppConfigRequest creates a request to invoke ExportMappCenterAppConfig API
func CreateExportMappCenterAppConfigRequest() (request *ExportMappCenterAppConfigRequest) {
	request = &ExportMappCenterAppConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ExportMappCenterAppConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateExportMappCenterAppConfigResponse creates a response to parse from ExportMappCenterAppConfig response
func CreateExportMappCenterAppConfigResponse() (response *ExportMappCenterAppConfigResponse) {
	response = &ExportMappCenterAppConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
