package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcubeWhitelistForIde invokes the mpaas.CreateMcubeWhitelistForIde API synchronously
func (client *Client) CreateMcubeWhitelistForIde(request *CreateMcubeWhitelistForIdeRequest) (response *CreateMcubeWhitelistForIdeResponse, err error) {
	response = CreateCreateMcubeWhitelistForIdeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcubeWhitelistForIdeWithChan invokes the mpaas.CreateMcubeWhitelistForIde API asynchronously
func (client *Client) CreateMcubeWhitelistForIdeWithChan(request *CreateMcubeWhitelistForIdeRequest) (<-chan *CreateMcubeWhitelistForIdeResponse, <-chan error) {
	responseChan := make(chan *CreateMcubeWhitelistForIdeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcubeWhitelistForIde(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcubeWhitelistForIdeWithCallback invokes the mpaas.CreateMcubeWhitelistForIde API asynchronously
func (client *Client) CreateMcubeWhitelistForIdeWithCallback(request *CreateMcubeWhitelistForIdeRequest, callback func(response *CreateMcubeWhitelistForIdeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcubeWhitelistForIdeResponse
		var err error
		defer close(result)
		response, err = client.CreateMcubeWhitelistForIde(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcubeWhitelistForIdeRequest is the request struct for api CreateMcubeWhitelistForIde
type CreateMcubeWhitelistForIdeRequest struct {
	*requests.RpcRequest
	UserId         string `position:"Body" name:"UserId"`
	TenantId       string `position:"Body" name:"TenantId"`
	WhitelistValue string `position:"Body" name:"WhitelistValue"`
	AppId          string `position:"Body" name:"AppId"`
	WorkspaceId    string `position:"Body" name:"WorkspaceId"`
}

// CreateMcubeWhitelistForIdeResponse is the response struct for api CreateMcubeWhitelistForIde
type CreateMcubeWhitelistForIdeResponse struct {
	*responses.BaseResponse
	ResultMessage               string                      `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                  string                      `json:"ResultCode" xml:"ResultCode"`
	RequestId                   string                      `json:"RequestId" xml:"RequestId"`
	CreateWhitelistForIdeResult CreateWhitelistForIdeResult `json:"CreateWhitelistForIdeResult" xml:"CreateWhitelistForIdeResult"`
}

// CreateCreateMcubeWhitelistForIdeRequest creates a request to invoke CreateMcubeWhitelistForIde API
func CreateCreateMcubeWhitelistForIdeRequest() (request *CreateMcubeWhitelistForIdeRequest) {
	request = &CreateMcubeWhitelistForIdeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcubeWhitelistForIde", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcubeWhitelistForIdeResponse creates a response to parse from CreateMcubeWhitelistForIde response
func CreateCreateMcubeWhitelistForIdeResponse() (response *CreateMcubeWhitelistForIdeResponse) {
	response = &CreateMcubeWhitelistForIdeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
