package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCasterLayout invokes the live.DeleteCasterLayout API synchronously
func (client *Client) DeleteCasterLayout(request *DeleteCasterLayoutRequest) (response *DeleteCasterLayoutResponse, err error) {
	response = CreateDeleteCasterLayoutResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCasterLayoutWithChan invokes the live.DeleteCasterLayout API asynchronously
func (client *Client) DeleteCasterLayoutWithChan(request *DeleteCasterLayoutRequest) (<-chan *DeleteCasterLayoutResponse, <-chan error) {
	responseChan := make(chan *DeleteCasterLayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCasterLayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCasterLayoutWithCallback invokes the live.DeleteCasterLayout API asynchronously
func (client *Client) DeleteCasterLayoutWithCallback(request *DeleteCasterLayoutRequest, callback func(response *DeleteCasterLayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCasterLayoutResponse
		var err error
		defer close(result)
		response, err = client.DeleteCasterLayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCasterLayoutRequest is the request struct for api DeleteCasterLayout
type DeleteCasterLayoutRequest struct {
	*requests.RpcRequest
	LayoutId string           `position:"Query" name:"LayoutId"`
	CasterId string           `position:"Query" name:"CasterId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteCasterLayoutResponse is the response struct for api DeleteCasterLayout
type DeleteCasterLayoutResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	LayoutId  string `json:"LayoutId" xml:"LayoutId"`
	CasterId  string `json:"CasterId" xml:"CasterId"`
}

// CreateDeleteCasterLayoutRequest creates a request to invoke DeleteCasterLayout API
func CreateDeleteCasterLayoutRequest() (request *DeleteCasterLayoutRequest) {
	request = &DeleteCasterLayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteCasterLayout", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCasterLayoutResponse creates a response to parse from DeleteCasterLayout response
func CreateDeleteCasterLayoutResponse() (response *DeleteCasterLayoutResponse) {
	response = &DeleteCasterLayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
