package iqa

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadDocument invokes the iqa.UploadDocument API synchronously
// api document: https://help.aliyun.com/api/iqa/uploaddocument.html
func (client *Client) UploadDocument(request *UploadDocumentRequest) (response *UploadDocumentResponse, err error) {
	response = CreateUploadDocumentResponse()
	err = client.DoAction(request, response)
	return
}

// UploadDocumentWithChan invokes the iqa.UploadDocument API asynchronously
// api document: https://help.aliyun.com/api/iqa/uploaddocument.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadDocumentWithChan(request *UploadDocumentRequest) (<-chan *UploadDocumentResponse, <-chan error) {
	responseChan := make(chan *UploadDocumentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadDocument(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadDocumentWithCallback invokes the iqa.UploadDocument API asynchronously
// api document: https://help.aliyun.com/api/iqa/uploaddocument.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UploadDocumentWithCallback(request *UploadDocumentRequest, callback func(response *UploadDocumentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadDocumentResponse
		var err error
		defer close(result)
		response, err = client.UploadDocument(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadDocumentRequest is the request struct for api UploadDocument
type UploadDocumentRequest struct {
	*requests.RpcRequest
	DocumentData    string `position:"Body" name:"DocumentData"`
	DocumentFileUrl string `position:"Body" name:"DocumentFileUrl"`
	ProjectId       string `position:"Body" name:"ProjectId"`
}

// UploadDocumentResponse is the response struct for api UploadDocument
type UploadDocumentResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ProjectId     string `json:"ProjectId" xml:"ProjectId"`
	TotalCount    int    `json:"TotalCount" xml:"TotalCount"`
	FileDataCount int    `json:"FileDataCount" xml:"FileDataCount"`
	JsonDataCount int    `json:"JsonDataCount" xml:"JsonDataCount"`
}

// CreateUploadDocumentRequest creates a request to invoke UploadDocument API
func CreateUploadDocumentRequest() (request *UploadDocumentRequest) {
	request = &UploadDocumentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("iqa", "2019-08-13", "UploadDocument", "iqa", "openAPI")
	return
}

// CreateUploadDocumentResponse creates a response to parse from UploadDocument response
func CreateUploadDocumentResponse() (response *UploadDocumentResponse) {
	response = &UploadDocumentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
