package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateParser invokes the iot.UpdateParser API synchronously
func (client *Client) UpdateParser(request *UpdateParserRequest) (response *UpdateParserResponse, err error) {
	response = CreateUpdateParserResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateParserWithChan invokes the iot.UpdateParser API asynchronously
func (client *Client) UpdateParserWithChan(request *UpdateParserRequest) (<-chan *UpdateParserResponse, <-chan error) {
	responseChan := make(chan *UpdateParserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateParser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateParserWithCallback invokes the iot.UpdateParser API asynchronously
func (client *Client) UpdateParserWithCallback(request *UpdateParserRequest, callback func(response *UpdateParserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateParserResponse
		var err error
		defer close(result)
		response, err = client.UpdateParser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateParserRequest is the request struct for api UpdateParser
type UpdateParserRequest struct {
	*requests.RpcRequest
	Description   string           `position:"Query" name:"Description"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ParserId      requests.Integer `position:"Query" name:"ParserId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	Name          string           `position:"Query" name:"Name"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// UpdateParserResponse is the response struct for api UpdateParser
type UpdateParserResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateParserRequest creates a request to invoke UpdateParser API
func CreateUpdateParserRequest() (request *UpdateParserRequest) {
	request = &UpdateParserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateParser", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateParserResponse creates a response to parse from UpdateParser response
func CreateUpdateParserResponse() (response *UpdateParserResponse) {
	response = &UpdateParserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
