package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindLicenseDevice invokes the iot.BindLicenseDevice API synchronously
func (client *Client) BindLicenseDevice(request *BindLicenseDeviceRequest) (response *BindLicenseDeviceResponse, err error) {
	response = CreateBindLicenseDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BindLicenseDeviceWithChan invokes the iot.BindLicenseDevice API asynchronously
func (client *Client) BindLicenseDeviceWithChan(request *BindLicenseDeviceRequest) (<-chan *BindLicenseDeviceResponse, <-chan error) {
	responseChan := make(chan *BindLicenseDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindLicenseDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindLicenseDeviceWithCallback invokes the iot.BindLicenseDevice API asynchronously
func (client *Client) BindLicenseDeviceWithCallback(request *BindLicenseDeviceRequest, callback func(response *BindLicenseDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindLicenseDeviceResponse
		var err error
		defer close(result)
		response, err = client.BindLicenseDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindLicenseDeviceRequest is the request struct for api BindLicenseDevice
type BindLicenseDeviceRequest struct {
	*requests.RpcRequest
	DeviceNameList *[]string `position:"Body" name:"DeviceNameList"  type:"Repeated"`
	IotInstanceId  string    `position:"Query" name:"IotInstanceId"`
	IotIdList      *[]string `position:"Body" name:"IotIdList"  type:"Repeated"`
	ProductKey     string    `position:"Query" name:"ProductKey"`
	ApiProduct     string    `position:"Body" name:"ApiProduct"`
	ApiRevision    string    `position:"Body" name:"ApiRevision"`
	LicenseCode    string    `position:"Query" name:"LicenseCode"`
}

// BindLicenseDeviceResponse is the response struct for api BindLicenseDevice
type BindLicenseDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateBindLicenseDeviceRequest creates a request to invoke BindLicenseDevice API
func CreateBindLicenseDeviceRequest() (request *BindLicenseDeviceRequest) {
	request = &BindLicenseDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BindLicenseDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateBindLicenseDeviceResponse creates a response to parse from BindLicenseDevice response
func CreateBindLicenseDeviceResponse() (response *BindLicenseDeviceResponse) {
	response = &BindLicenseDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
