package imagerecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TaggingAdImage invokes the imagerecog.TaggingAdImage API synchronously
func (client *Client) TaggingAdImage(request *TaggingAdImageRequest) (response *TaggingAdImageResponse, err error) {
	response = CreateTaggingAdImageResponse()
	err = client.DoAction(request, response)
	return
}

// TaggingAdImageWithChan invokes the imagerecog.TaggingAdImage API asynchronously
func (client *Client) TaggingAdImageWithChan(request *TaggingAdImageRequest) (<-chan *TaggingAdImageResponse, <-chan error) {
	responseChan := make(chan *TaggingAdImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TaggingAdImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TaggingAdImageWithCallback invokes the imagerecog.TaggingAdImage API asynchronously
func (client *Client) TaggingAdImageWithCallback(request *TaggingAdImageRequest, callback func(response *TaggingAdImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TaggingAdImageResponse
		var err error
		defer close(result)
		response, err = client.TaggingAdImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TaggingAdImageRequest is the request struct for api TaggingAdImage
type TaggingAdImageRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	OssFile            string           `position:"Query" name:"OssFile"`
	ImageType          requests.Integer `position:"Body" name:"ImageType"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	Async              requests.Boolean `position:"Body" name:"Async"`
	ImageURL           string           `position:"Body" name:"ImageURL"`
}

// TaggingAdImageResponse is the response struct for api TaggingAdImage
type TaggingAdImageResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Code      string               `json:"Code" xml:"Code"`
	Message   string               `json:"Message" xml:"Message"`
	Data      DataInTaggingAdImage `json:"Data" xml:"Data"`
}

// CreateTaggingAdImageRequest creates a request to invoke TaggingAdImage API
func CreateTaggingAdImageRequest() (request *TaggingAdImageRequest) {
	request = &TaggingAdImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imagerecog", "2019-09-30", "TaggingAdImage", "", "")
	request.Method = requests.POST
	return
}

// CreateTaggingAdImageResponse creates a response to parse from TaggingAdImage response
func CreateTaggingAdImageResponse() (response *TaggingAdImageResponse) {
	response = &TaggingAdImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
