package imagerecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClassifyingRubbish invokes the imagerecog.ClassifyingRubbish API synchronously
func (client *Client) ClassifyingRubbish(request *ClassifyingRubbishRequest) (response *ClassifyingRubbishResponse, err error) {
	response = CreateClassifyingRubbishResponse()
	err = client.DoAction(request, response)
	return
}

// ClassifyingRubbishWithChan invokes the imagerecog.ClassifyingRubbish API asynchronously
func (client *Client) ClassifyingRubbishWithChan(request *ClassifyingRubbishRequest) (<-chan *ClassifyingRubbishResponse, <-chan error) {
	responseChan := make(chan *ClassifyingRubbishResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClassifyingRubbish(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClassifyingRubbishWithCallback invokes the imagerecog.ClassifyingRubbish API asynchronously
func (client *Client) ClassifyingRubbishWithCallback(request *ClassifyingRubbishRequest, callback func(response *ClassifyingRubbishResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClassifyingRubbishResponse
		var err error
		defer close(result)
		response, err = client.ClassifyingRubbish(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClassifyingRubbishRequest is the request struct for api ClassifyingRubbish
type ClassifyingRubbishRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	OssFile            string           `position:"Query" name:"OssFile"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	ImageURL           string           `position:"Body" name:"ImageURL"`
}

// ClassifyingRubbishResponse is the response struct for api ClassifyingRubbish
type ClassifyingRubbishResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateClassifyingRubbishRequest creates a request to invoke ClassifyingRubbish API
func CreateClassifyingRubbishRequest() (request *ClassifyingRubbishRequest) {
	request = &ClassifyingRubbishRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imagerecog", "2019-09-30", "ClassifyingRubbish", "", "")
	request.Method = requests.POST
	return
}

// CreateClassifyingRubbishResponse creates a response to parse from ClassifyingRubbish response
func CreateClassifyingRubbishResponse() (response *ClassifyingRubbishResponse) {
	response = &ClassifyingRubbishResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
