package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TranslateMed invokes the imageprocess.TranslateMed API synchronously
func (client *Client) TranslateMed(request *TranslateMedRequest) (response *TranslateMedResponse, err error) {
	response = CreateTranslateMedResponse()
	err = client.DoAction(request, response)
	return
}

// TranslateMedWithChan invokes the imageprocess.TranslateMed API asynchronously
func (client *Client) TranslateMedWithChan(request *TranslateMedRequest) (<-chan *TranslateMedResponse, <-chan error) {
	responseChan := make(chan *TranslateMedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TranslateMed(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TranslateMedWithCallback invokes the imageprocess.TranslateMed API asynchronously
func (client *Client) TranslateMedWithCallback(request *TranslateMedRequest, callback func(response *TranslateMedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TranslateMedResponse
		var err error
		defer close(result)
		response, err = client.TranslateMed(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TranslateMedRequest is the request struct for api TranslateMed
type TranslateMedRequest struct {
	*requests.RpcRequest
	ToLanguage   string `position:"Body" name:"ToLanguage"`
	Text         string `position:"Body" name:"Text"`
	FromLanguage string `position:"Body" name:"FromLanguage"`
}

// TranslateMedResponse is the response struct for api TranslateMed
type TranslateMedResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateTranslateMedRequest creates a request to invoke TranslateMed API
func CreateTranslateMedRequest() (request *TranslateMedRequest) {
	request = &TranslateMedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "TranslateMed", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTranslateMedResponse creates a response to parse from TranslateMed response
func CreateTranslateMedResponse() (response *TranslateMedResponse) {
	response = &TranslateMedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
