package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FileAsyncScanV2 invokes the green.FileAsyncScanV2 API synchronously
func (client *Client) FileAsyncScanV2(request *FileAsyncScanV2Request) (response *FileAsyncScanV2Response, err error) {
	response = CreateFileAsyncScanV2Response()
	err = client.DoAction(request, response)
	return
}

// FileAsyncScanV2WithChan invokes the green.FileAsyncScanV2 API asynchronously
func (client *Client) FileAsyncScanV2WithChan(request *FileAsyncScanV2Request) (<-chan *FileAsyncScanV2Response, <-chan error) {
	responseChan := make(chan *FileAsyncScanV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FileAsyncScanV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FileAsyncScanV2WithCallback invokes the green.FileAsyncScanV2 API asynchronously
func (client *Client) FileAsyncScanV2WithCallback(request *FileAsyncScanV2Request, callback func(response *FileAsyncScanV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FileAsyncScanV2Response
		var err error
		defer close(result)
		response, err = client.FileAsyncScanV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FileAsyncScanV2Request is the request struct for api FileAsyncScanV2
type FileAsyncScanV2Request struct {
	*requests.RoaRequest
}

// FileAsyncScanV2Response is the response struct for api FileAsyncScanV2
type FileAsyncScanV2Response struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateFileAsyncScanV2Request creates a request to invoke FileAsyncScanV2 API
func CreateFileAsyncScanV2Request() (request *FileAsyncScanV2Request) {
	request = &FileAsyncScanV2Request{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "FileAsyncScanV2", "/green/file/asyncscanv2", "", "")
	request.Method = requests.POST
	return
}

// CreateFileAsyncScanV2Response creates a response to parse from FileAsyncScanV2 response
func CreateFileAsyncScanV2Response() (response *FileAsyncScanV2Response) {
	response = &FileAsyncScanV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
