package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwapFacialFeatures invokes the facebody.SwapFacialFeatures API synchronously
func (client *Client) SwapFacialFeatures(request *SwapFacialFeaturesRequest) (response *SwapFacialFeaturesResponse, err error) {
	response = CreateSwapFacialFeaturesResponse()
	err = client.DoAction(request, response)
	return
}

// SwapFacialFeaturesWithChan invokes the facebody.SwapFacialFeatures API asynchronously
func (client *Client) SwapFacialFeaturesWithChan(request *SwapFacialFeaturesRequest) (<-chan *SwapFacialFeaturesResponse, <-chan error) {
	responseChan := make(chan *SwapFacialFeaturesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwapFacialFeatures(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwapFacialFeaturesWithCallback invokes the facebody.SwapFacialFeatures API asynchronously
func (client *Client) SwapFacialFeaturesWithCallback(request *SwapFacialFeaturesRequest, callback func(response *SwapFacialFeaturesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwapFacialFeaturesResponse
		var err error
		defer close(result)
		response, err = client.SwapFacialFeatures(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwapFacialFeaturesRequest is the request struct for api SwapFacialFeatures
type SwapFacialFeaturesRequest struct {
	*requests.RpcRequest
	TargetImageURL     string           `position:"Body" name:"TargetImageURL"`
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	SourceImageData    string           `position:"Body" name:"SourceImageData"`
	OssFile            string           `position:"Query" name:"OssFile"`
	SourceImageURL     string           `position:"Body" name:"SourceImageURL"`
	TargetImageData    string           `position:"Body" name:"TargetImageData"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	EditPart           string           `position:"Body" name:"EditPart"`
}

// SwapFacialFeaturesResponse is the response struct for api SwapFacialFeatures
type SwapFacialFeaturesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSwapFacialFeaturesRequest creates a request to invoke SwapFacialFeatures API
func CreateSwapFacialFeaturesRequest() (request *SwapFacialFeaturesRequest) {
	request = &SwapFacialFeaturesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "SwapFacialFeatures", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwapFacialFeaturesResponse creates a response to parse from SwapFacialFeatures response
func CreateSwapFacialFeaturesResponse() (response *SwapFacialFeaturesResponse) {
	response = &SwapFacialFeaturesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
