package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTargets invokes the eventbridge.DeleteTargets API synchronously
func (client *Client) DeleteTargets(request *DeleteTargetsRequest) (response *DeleteTargetsResponse, err error) {
	response = CreateDeleteTargetsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTargetsWithChan invokes the eventbridge.DeleteTargets API asynchronously
func (client *Client) DeleteTargetsWithChan(request *DeleteTargetsRequest) (<-chan *DeleteTargetsResponse, <-chan error) {
	responseChan := make(chan *DeleteTargetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTargets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTargetsWithCallback invokes the eventbridge.DeleteTargets API asynchronously
func (client *Client) DeleteTargetsWithCallback(request *DeleteTargetsRequest, callback func(response *DeleteTargetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTargetsResponse
		var err error
		defer close(result)
		response, err = client.DeleteTargets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTargetsRequest is the request struct for api DeleteTargets
type DeleteTargetsRequest struct {
	*requests.RpcRequest
	TargetIds    *[]string `position:"Query" name:"TargetIds"  type:"Json"`
	RuleName     string    `position:"Query" name:"RuleName"`
	EventBusName string    `position:"Query" name:"EventBusName"`
}

// DeleteTargetsResponse is the response struct for api DeleteTargets
type DeleteTargetsResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteTargetsRequest creates a request to invoke DeleteTargets API
func CreateDeleteTargetsRequest() (request *DeleteTargetsRequest) {
	request = &DeleteTargetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "DeleteTargets", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTargetsResponse creates a response to parse from DeleteTargets response
func CreateDeleteTargetsResponse() (response *DeleteTargetsResponse) {
	response = &DeleteTargetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
