package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTargets invokes the eventbridge.CreateTargets API synchronously
func (client *Client) CreateTargets(request *CreateTargetsRequest) (response *CreateTargetsResponse, err error) {
	response = CreateCreateTargetsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTargetsWithChan invokes the eventbridge.CreateTargets API asynchronously
func (client *Client) CreateTargetsWithChan(request *CreateTargetsRequest) (<-chan *CreateTargetsResponse, <-chan error) {
	responseChan := make(chan *CreateTargetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTargets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTargetsWithCallback invokes the eventbridge.CreateTargets API asynchronously
func (client *Client) CreateTargetsWithCallback(request *CreateTargetsRequest, callback func(response *CreateTargetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTargetsResponse
		var err error
		defer close(result)
		response, err = client.CreateTargets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTargetsRequest is the request struct for api CreateTargets
type CreateTargetsRequest struct {
	*requests.RpcRequest
	ClientToken  string                  `position:"Query" name:"ClientToken"`
	RuleName     string                  `position:"Query" name:"RuleName"`
	EventBusName string                  `position:"Query" name:"EventBusName"`
	Targets      *[]CreateTargetsTargets `position:"Query" name:"Targets"  type:"Json"`
}

// CreateTargetsTargets is a repeated param struct in CreateTargetsRequest
type CreateTargetsTargets struct {
	Endpoint          string                               `name:"Endpoint"`
	PushRetryStrategy string                               `name:"PushRetryStrategy"`
	ParamList         *[]CreateTargetsTargetsParamListItem `name:"ParamList" type:"Repeated"`
	Id                string                               `name:"Id"`
	Type              string                               `name:"Type"`
}

// CreateTargetsTargetsParamListItem is a repeated param struct in CreateTargetsRequest
type CreateTargetsTargetsParamListItem struct {
	Template    string `name:"Template"`
	ResourceKey string `name:"ResourceKey"`
	Form        string `name:"Form"`
	Value       string `name:"Value"`
}

// CreateTargetsResponse is the response struct for api CreateTargets
type CreateTargetsResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateTargetsRequest creates a request to invoke CreateTargets API
func CreateCreateTargetsRequest() (request *CreateTargetsRequest) {
	request = &CreateTargetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "CreateTargets", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTargetsResponse creates a response to parse from CreateTargets response
func CreateCreateTargetsResponse() (response *CreateTargetsResponse) {
	response = &CreateTargetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
