package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNotificationConfiguration invokes the ess.DeleteNotificationConfiguration API synchronously
func (client *Client) DeleteNotificationConfiguration(request *DeleteNotificationConfigurationRequest) (response *DeleteNotificationConfigurationResponse, err error) {
	response = CreateDeleteNotificationConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNotificationConfigurationWithChan invokes the ess.DeleteNotificationConfiguration API asynchronously
func (client *Client) DeleteNotificationConfigurationWithChan(request *DeleteNotificationConfigurationRequest) (<-chan *DeleteNotificationConfigurationResponse, <-chan error) {
	responseChan := make(chan *DeleteNotificationConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNotificationConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNotificationConfigurationWithCallback invokes the ess.DeleteNotificationConfiguration API asynchronously
func (client *Client) DeleteNotificationConfigurationWithCallback(request *DeleteNotificationConfigurationRequest, callback func(response *DeleteNotificationConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNotificationConfigurationResponse
		var err error
		defer close(result)
		response, err = client.DeleteNotificationConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNotificationConfigurationRequest is the request struct for api DeleteNotificationConfiguration
type DeleteNotificationConfigurationRequest struct {
	*requests.RpcRequest
	ScalingGroupId       string           `position:"Query" name:"ScalingGroupId"`
	NotificationArn      string           `position:"Query" name:"NotificationArn"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteNotificationConfigurationResponse is the response struct for api DeleteNotificationConfiguration
type DeleteNotificationConfigurationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNotificationConfigurationRequest creates a request to invoke DeleteNotificationConfiguration API
func CreateDeleteNotificationConfigurationRequest() (request *DeleteNotificationConfigurationRequest) {
	request = &DeleteNotificationConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DeleteNotificationConfiguration", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNotificationConfigurationResponse creates a response to parse from DeleteNotificationConfiguration response
func CreateDeleteNotificationConfigurationResponse() (response *DeleteNotificationConfigurationResponse) {
	response = &DeleteNotificationConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
