package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewARMServerInstance invokes the ens.RenewARMServerInstance API synchronously
func (client *Client) RenewARMServerInstance(request *RenewARMServerInstanceRequest) (response *RenewARMServerInstanceResponse, err error) {
	response = CreateRenewARMServerInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RenewARMServerInstanceWithChan invokes the ens.RenewARMServerInstance API asynchronously
func (client *Client) RenewARMServerInstanceWithChan(request *RenewARMServerInstanceRequest) (<-chan *RenewARMServerInstanceResponse, <-chan error) {
	responseChan := make(chan *RenewARMServerInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewARMServerInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewARMServerInstanceWithCallback invokes the ens.RenewARMServerInstance API asynchronously
func (client *Client) RenewARMServerInstanceWithCallback(request *RenewARMServerInstanceRequest, callback func(response *RenewARMServerInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewARMServerInstanceResponse
		var err error
		defer close(result)
		response, err = client.RenewARMServerInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewARMServerInstanceRequest is the request struct for api RenewARMServerInstance
type RenewARMServerInstanceRequest struct {
	*requests.RpcRequest
	Period     requests.Integer `position:"Query" name:"Period"`
	PeriodUnit string           `position:"Query" name:"PeriodUnit"`
	InstanceId string           `position:"Query" name:"InstanceId"`
}

// RenewARMServerInstanceResponse is the response struct for api RenewARMServerInstance
type RenewARMServerInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRenewARMServerInstanceRequest creates a request to invoke RenewARMServerInstance API
func CreateRenewARMServerInstanceRequest() (request *RenewARMServerInstanceRequest) {
	request = &RenewARMServerInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "RenewARMServerInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRenewARMServerInstanceResponse creates a response to parse from RenewARMServerInstance response
func CreateRenewARMServerInstanceResponse() (response *RenewARMServerInstanceResponse) {
	response = &RenewARMServerInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
