package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncUsers invokes the ehpc.SyncUsers API synchronously
func (client *Client) SyncUsers(request *SyncUsersRequest) (response *SyncUsersResponse, err error) {
	response = CreateSyncUsersResponse()
	err = client.DoAction(request, response)
	return
}

// SyncUsersWithChan invokes the ehpc.SyncUsers API asynchronously
func (client *Client) SyncUsersWithChan(request *SyncUsersRequest) (<-chan *SyncUsersResponse, <-chan error) {
	responseChan := make(chan *SyncUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncUsersWithCallback invokes the ehpc.SyncUsers API asynchronously
func (client *Client) SyncUsersWithCallback(request *SyncUsersRequest, callback func(response *SyncUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncUsersResponse
		var err error
		defer close(result)
		response, err = client.SyncUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncUsersRequest is the request struct for api SyncUsers
type SyncUsersRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// SyncUsersResponse is the response struct for api SyncUsers
type SyncUsersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSyncUsersRequest creates a request to invoke SyncUsers API
func CreateSyncUsersRequest() (request *SyncUsersRequest) {
	request = &SyncUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "SyncUsers", "", "")
	request.Method = requests.GET
	return
}

// CreateSyncUsersResponse creates a response to parse from SyncUsers response
func CreateSyncUsersResponse() (response *SyncUsersResponse) {
	response = &SyncUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
