package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserImage invokes the ehpc.GetUserImage API synchronously
func (client *Client) GetUserImage(request *GetUserImageRequest) (response *GetUserImageResponse, err error) {
	response = CreateGetUserImageResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserImageWithChan invokes the ehpc.GetUserImage API asynchronously
func (client *Client) GetUserImageWithChan(request *GetUserImageRequest) (<-chan *GetUserImageResponse, <-chan error) {
	responseChan := make(chan *GetUserImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserImageWithCallback invokes the ehpc.GetUserImage API asynchronously
func (client *Client) GetUserImageWithCallback(request *GetUserImageRequest, callback func(response *GetUserImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserImageResponse
		var err error
		defer close(result)
		response, err = client.GetUserImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserImageRequest is the request struct for api GetUserImage
type GetUserImageRequest struct {
	*requests.RpcRequest
	OSSBucket     string `position:"Query" name:"OSSBucket"`
	OSSEndPoint   string `position:"Query" name:"OSSEndPoint"`
	ClusterId     string `position:"Query" name:"ClusterId"`
	ContainerType string `position:"Query" name:"ContainerType"`
	ImagePath     string `position:"Query" name:"ImagePath"`
	ImageName     string `position:"Query" name:"ImageName"`
}

// GetUserImageResponse is the response struct for api GetUserImage
type GetUserImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetUserImageRequest creates a request to invoke GetUserImage API
func CreateGetUserImageRequest() (request *GetUserImageRequest) {
	request = &GetUserImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "GetUserImage", "", "")
	request.Method = requests.GET
	return
}

// CreateGetUserImageResponse creates a response to parse from GetUserImage response
func CreateGetUserImageResponse() (response *GetUserImageResponse) {
	response = &GetUserImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
