package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListK8sConfigMaps invokes the edas.ListK8sConfigMaps API synchronously
func (client *Client) ListK8sConfigMaps(request *ListK8sConfigMapsRequest) (response *ListK8sConfigMapsResponse, err error) {
	response = CreateListK8sConfigMapsResponse()
	err = client.DoAction(request, response)
	return
}

// ListK8sConfigMapsWithChan invokes the edas.ListK8sConfigMaps API asynchronously
func (client *Client) ListK8sConfigMapsWithChan(request *ListK8sConfigMapsRequest) (<-chan *ListK8sConfigMapsResponse, <-chan error) {
	responseChan := make(chan *ListK8sConfigMapsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListK8sConfigMaps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListK8sConfigMapsWithCallback invokes the edas.ListK8sConfigMaps API asynchronously
func (client *Client) ListK8sConfigMapsWithCallback(request *ListK8sConfigMapsRequest, callback func(response *ListK8sConfigMapsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListK8sConfigMapsResponse
		var err error
		defer close(result)
		response, err = client.ListK8sConfigMaps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListK8sConfigMapsRequest is the request struct for api ListK8sConfigMaps
type ListK8sConfigMapsRequest struct {
	*requests.RoaRequest
	Condition       string `position:"Query" name:"Condition"`
	PageNo          string `position:"Query" name:"PageNo"`
	Namespace       string `position:"Query" name:"Namespace"`
	PageSize        string `position:"Query" name:"PageSize"`
	ClusterId       string `position:"Query" name:"ClusterId"`
	ShowRelatedApps string `position:"Query" name:"ShowRelatedApps"`
}

// ListK8sConfigMapsResponse is the response struct for api ListK8sConfigMaps
type ListK8sConfigMapsResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListK8sConfigMapsRequest creates a request to invoke ListK8sConfigMaps API
func CreateListK8sConfigMapsRequest() (request *ListK8sConfigMapsRequest) {
	request = &ListK8sConfigMapsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListK8sConfigMaps", "/pop/v5/k8s/acs/k8s_config_map", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListK8sConfigMapsResponse creates a response to parse from ListK8sConfigMaps response
func CreateListK8sConfigMapsResponse() (response *ListK8sConfigMapsResponse) {
	response = &ListK8sConfigMapsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
