package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceListPage invokes the edas.GetServiceListPage API synchronously
func (client *Client) GetServiceListPage(request *GetServiceListPageRequest) (response *GetServiceListPageResponse, err error) {
	response = CreateGetServiceListPageResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceListPageWithChan invokes the edas.GetServiceListPage API asynchronously
func (client *Client) GetServiceListPageWithChan(request *GetServiceListPageRequest) (<-chan *GetServiceListPageResponse, <-chan error) {
	responseChan := make(chan *GetServiceListPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceListPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceListPageWithCallback invokes the edas.GetServiceListPage API asynchronously
func (client *Client) GetServiceListPageWithCallback(request *GetServiceListPageRequest, callback func(response *GetServiceListPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceListPageResponse
		var err error
		defer close(result)
		response, err = client.GetServiceListPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceListPageRequest is the request struct for api GetServiceListPage
type GetServiceListPageRequest struct {
	*requests.RoaRequest
	ServiceType string `position:"Query" name:"serviceType"`
	Side        string `position:"Query" name:"side"`
	Size        string `position:"Query" name:"size"`
	Origin      string `position:"Query" name:"origin"`
	SearchType  string `position:"Query" name:"searchType"`
	Namespace   string `position:"Query" name:"namespace"`
	Page        string `position:"Query" name:"page"`
	Region      string `position:"Query" name:"region"`
	SearchValue string `position:"Query" name:"searchValue"`
}

// GetServiceListPageResponse is the response struct for api GetServiceListPage
type GetServiceListPageResponse struct {
	*responses.BaseResponse
	Code    int                      `json:"Code" xml:"Code"`
	Message string                   `json:"Message" xml:"Message"`
	Success bool                     `json:"Success" xml:"Success"`
	Data    DataInGetServiceListPage `json:"Data" xml:"Data"`
}

// CreateGetServiceListPageRequest creates a request to invoke GetServiceListPage API
func CreateGetServiceListPageRequest() (request *GetServiceListPageRequest) {
	request = &GetServiceListPageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetServiceListPage", "/pop/sp/api/mseForOam/getServiceListPage", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceListPageResponse creates a response to parse from GetServiceListPage response
func CreateGetServiceListPageResponse() (response *GetServiceListPageResponse) {
	response = &GetServiceListPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
