package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindEcsSlb invokes the edas.BindEcsSlb API synchronously
func (client *Client) BindEcsSlb(request *BindEcsSlbRequest) (response *BindEcsSlbResponse, err error) {
	response = CreateBindEcsSlbResponse()
	err = client.DoAction(request, response)
	return
}

// BindEcsSlbWithChan invokes the edas.BindEcsSlb API asynchronously
func (client *Client) BindEcsSlbWithChan(request *BindEcsSlbRequest) (<-chan *BindEcsSlbResponse, <-chan error) {
	responseChan := make(chan *BindEcsSlbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindEcsSlb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindEcsSlbWithCallback invokes the edas.BindEcsSlb API asynchronously
func (client *Client) BindEcsSlbWithCallback(request *BindEcsSlbRequest, callback func(response *BindEcsSlbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindEcsSlbResponse
		var err error
		defer close(result)
		response, err = client.BindEcsSlb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindEcsSlbRequest is the request struct for api BindEcsSlb
type BindEcsSlbRequest struct {
	*requests.RoaRequest
	VServerGroupId         string `position:"Query" name:"VServerGroupId"`
	ListenerPort           string `position:"Query" name:"ListenerPort"`
	VForwardingUrlRule     string `position:"Query" name:"VForwardingUrlRule"`
	SlbId                  string `position:"Query" name:"SlbId"`
	DeployGroupId          string `position:"Query" name:"DeployGroupId"`
	ListenerHealthCheckUrl string `position:"Query" name:"ListenerHealthCheckUrl"`
	AppId                  string `position:"Query" name:"AppId"`
	ListenerProtocol       string `position:"Query" name:"ListenerProtocol"`
	VServerGroupName       string `position:"Query" name:"VServerGroupName"`
}

// BindEcsSlbResponse is the response struct for api BindEcsSlb
type BindEcsSlbResponse struct {
	*responses.BaseResponse
	ChangeOrderId string `json:"ChangeOrderId" xml:"ChangeOrderId"`
	Code          int    `json:"Code" xml:"Code"`
	Message       string `json:"Message" xml:"Message"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateBindEcsSlbRequest creates a request to invoke BindEcsSlb API
func CreateBindEcsSlbRequest() (request *BindEcsSlbRequest) {
	request = &BindEcsSlbRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "BindEcsSlb", "/pop/v5/app/slb/bind_slb", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindEcsSlbResponse creates a response to parse from BindEcsSlb response
func CreateBindEcsSlbResponse() (response *BindEcsSlbResponse) {
	response = &BindEcsSlbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
