package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDesktops invokes the ecd.StopDesktops API synchronously
func (client *Client) StopDesktops(request *StopDesktopsRequest) (response *StopDesktopsResponse, err error) {
	response = CreateStopDesktopsResponse()
	err = client.DoAction(request, response)
	return
}

// StopDesktopsWithChan invokes the ecd.StopDesktops API asynchronously
func (client *Client) StopDesktopsWithChan(request *StopDesktopsRequest) (<-chan *StopDesktopsResponse, <-chan error) {
	responseChan := make(chan *StopDesktopsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDesktops(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDesktopsWithCallback invokes the ecd.StopDesktops API asynchronously
func (client *Client) StopDesktopsWithCallback(request *StopDesktopsRequest, callback func(response *StopDesktopsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDesktopsResponse
		var err error
		defer close(result)
		response, err = client.StopDesktops(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDesktopsRequest is the request struct for api StopDesktops
type StopDesktopsRequest struct {
	*requests.RpcRequest
	StoppedMode string    `position:"Query" name:"StoppedMode"`
	DesktopId   *[]string `position:"Query" name:"DesktopId"  type:"Repeated"`
}

// StopDesktopsResponse is the response struct for api StopDesktops
type StopDesktopsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopDesktopsRequest creates a request to invoke StopDesktops API
func CreateStopDesktopsRequest() (request *StopDesktopsRequest) {
	request = &StopDesktopsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "StopDesktops", "", "")
	request.Method = requests.POST
	return
}

// CreateStopDesktopsResponse creates a response to parse from StopDesktops response
func CreateStopDesktopsResponse() (response *StopDesktopsResponse) {
	response = &StopDesktopsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
