package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyUserToDesktopGroup invokes the ecd.ModifyUserToDesktopGroup API synchronously
func (client *Client) ModifyUserToDesktopGroup(request *ModifyUserToDesktopGroupRequest) (response *ModifyUserToDesktopGroupResponse, err error) {
	response = CreateModifyUserToDesktopGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyUserToDesktopGroupWithChan invokes the ecd.ModifyUserToDesktopGroup API asynchronously
func (client *Client) ModifyUserToDesktopGroupWithChan(request *ModifyUserToDesktopGroupRequest) (<-chan *ModifyUserToDesktopGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyUserToDesktopGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyUserToDesktopGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyUserToDesktopGroupWithCallback invokes the ecd.ModifyUserToDesktopGroup API asynchronously
func (client *Client) ModifyUserToDesktopGroupWithCallback(request *ModifyUserToDesktopGroupRequest, callback func(response *ModifyUserToDesktopGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyUserToDesktopGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyUserToDesktopGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyUserToDesktopGroupRequest is the request struct for api ModifyUserToDesktopGroup
type ModifyUserToDesktopGroupRequest struct {
	*requests.RpcRequest
	OldEndUserIds  *[]string `position:"Query" name:"OldEndUserIds"  type:"Repeated"`
	DesktopGroupId string    `position:"Query" name:"DesktopGroupId"`
	NewEndUserIds  *[]string `position:"Query" name:"NewEndUserIds"  type:"Repeated"`
}

// ModifyUserToDesktopGroupResponse is the response struct for api ModifyUserToDesktopGroup
type ModifyUserToDesktopGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyUserToDesktopGroupRequest creates a request to invoke ModifyUserToDesktopGroup API
func CreateModifyUserToDesktopGroupRequest() (request *ModifyUserToDesktopGroupRequest) {
	request = &ModifyUserToDesktopGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyUserToDesktopGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyUserToDesktopGroupResponse creates a response to parse from ModifyUserToDesktopGroup response
func CreateModifyUserToDesktopGroupResponse() (response *ModifyUserToDesktopGroupResponse) {
	response = &ModifyUserToDesktopGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
