package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPolicyGroup invokes the ecd.ModifyPolicyGroup API synchronously
func (client *Client) ModifyPolicyGroup(request *ModifyPolicyGroupRequest) (response *ModifyPolicyGroupResponse, err error) {
	response = CreateModifyPolicyGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPolicyGroupWithChan invokes the ecd.ModifyPolicyGroup API asynchronously
func (client *Client) ModifyPolicyGroupWithChan(request *ModifyPolicyGroupRequest) (<-chan *ModifyPolicyGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyPolicyGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPolicyGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPolicyGroupWithCallback invokes the ecd.ModifyPolicyGroup API asynchronously
func (client *Client) ModifyPolicyGroupWithCallback(request *ModifyPolicyGroupRequest, callback func(response *ModifyPolicyGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPolicyGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyPolicyGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPolicyGroupRequest is the request struct for api ModifyPolicyGroup
type ModifyPolicyGroupRequest struct {
	*requests.RpcRequest
	WatermarkCustomText         string                                          `position:"Query" name:"WatermarkCustomText"`
	PreemptLogin                string                                          `position:"Query" name:"PreemptLogin"`
	ClientType                  *[]ModifyPolicyGroupClientType                  `position:"Query" name:"ClientType"  type:"Repeated"`
	RevokeSecurityPolicyRule    *[]ModifyPolicyGroupRevokeSecurityPolicyRule    `position:"Query" name:"RevokeSecurityPolicyRule"  type:"Repeated"`
	UsbSupplyRedirectRule       *[]ModifyPolicyGroupUsbSupplyRedirectRule       `position:"Query" name:"UsbSupplyRedirectRule"  type:"Repeated"`
	PrinterRedirection          string                                          `position:"Query" name:"PrinterRedirection"`
	PreemptLoginUser            *[]string                                       `position:"Query" name:"PreemptLoginUser"  type:"Repeated"`
	DomainList                  string                                          `position:"Query" name:"DomainList"`
	NetRedirect                 string                                          `position:"Query" name:"NetRedirect"`
	LocalDrive                  string                                          `position:"Query" name:"LocalDrive"`
	AuthorizeSecurityPolicyRule *[]ModifyPolicyGroupAuthorizeSecurityPolicyRule `position:"Query" name:"AuthorizeSecurityPolicyRule"  type:"Repeated"`
	Recording                   string                                          `position:"Query" name:"Recording"`
	Clipboard                   string                                          `position:"Query" name:"Clipboard"`
	RecordingFps                requests.Integer                                `position:"Query" name:"RecordingFps"`
	UsbRedirect                 string                                          `position:"Query" name:"UsbRedirect"`
	WatermarkType               string                                          `position:"Query" name:"WatermarkType"`
	RecordingStartTime          string                                          `position:"Query" name:"RecordingStartTime"`
	RevokeAccessPolicyRule      *[]ModifyPolicyGroupRevokeAccessPolicyRule      `position:"Query" name:"RevokeAccessPolicyRule"  type:"Repeated"`
	Watermark                   string                                          `position:"Query" name:"Watermark"`
	CameraRedirect              string                                          `position:"Query" name:"CameraRedirect"`
	Html5Access                 string                                          `position:"Query" name:"Html5Access"`
	GpuAcceleration             string                                          `position:"Query" name:"GpuAcceleration"`
	Html5FileTransfer           string                                          `position:"Query" name:"Html5FileTransfer"`
	AuthorizeAccessPolicyRule   *[]ModifyPolicyGroupAuthorizeAccessPolicyRule   `position:"Query" name:"AuthorizeAccessPolicyRule"  type:"Repeated"`
	VisualQuality               string                                          `position:"Query" name:"VisualQuality"`
	WatermarkTransparency       string                                          `position:"Query" name:"WatermarkTransparency"`
	Name                        string                                          `position:"Query" name:"Name"`
	RecordingEndTime            string                                          `position:"Query" name:"RecordingEndTime"`
	PolicyGroupId               string                                          `position:"Query" name:"PolicyGroupId"`
}

// ModifyPolicyGroupClientType is a repeated param struct in ModifyPolicyGroupRequest
type ModifyPolicyGroupClientType struct {
	ClientType string `name:"ClientType"`
	Status     string `name:"Status"`
}

// ModifyPolicyGroupRevokeSecurityPolicyRule is a repeated param struct in ModifyPolicyGroupRequest
type ModifyPolicyGroupRevokeSecurityPolicyRule struct {
	PortRange   string `name:"PortRange"`
	IpProtocol  string `name:"IpProtocol"`
	Description string `name:"Description"`
	Type        string `name:"Type"`
	Priority    string `name:"Priority"`
	CidrIp      string `name:"CidrIp"`
	Policy      string `name:"Policy"`
}

// ModifyPolicyGroupUsbSupplyRedirectRule is a repeated param struct in ModifyPolicyGroupRequest
type ModifyPolicyGroupUsbSupplyRedirectRule struct {
	ProductId       string `name:"ProductId"`
	DeviceSubclass  string `name:"DeviceSubclass"`
	UsbRedirectType string `name:"UsbRedirectType"`
	VendorId        string `name:"VendorId"`
	Description     string `name:"Description"`
	DeviceClass     string `name:"DeviceClass"`
	UsbRuleType     string `name:"UsbRuleType"`
}

// ModifyPolicyGroupAuthorizeSecurityPolicyRule is a repeated param struct in ModifyPolicyGroupRequest
type ModifyPolicyGroupAuthorizeSecurityPolicyRule struct {
	PortRange   string `name:"PortRange"`
	IpProtocol  string `name:"IpProtocol"`
	Description string `name:"Description"`
	Type        string `name:"Type"`
	Priority    string `name:"Priority"`
	CidrIp      string `name:"CidrIp"`
	Policy      string `name:"Policy"`
}

// ModifyPolicyGroupRevokeAccessPolicyRule is a repeated param struct in ModifyPolicyGroupRequest
type ModifyPolicyGroupRevokeAccessPolicyRule struct {
	Description string `name:"Description"`
	CidrIp      string `name:"CidrIp"`
}

// ModifyPolicyGroupAuthorizeAccessPolicyRule is a repeated param struct in ModifyPolicyGroupRequest
type ModifyPolicyGroupAuthorizeAccessPolicyRule struct {
	Description string `name:"Description"`
	CidrIp      string `name:"CidrIp"`
}

// ModifyPolicyGroupResponse is the response struct for api ModifyPolicyGroup
type ModifyPolicyGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPolicyGroupRequest creates a request to invoke ModifyPolicyGroup API
func CreateModifyPolicyGroupRequest() (request *ModifyPolicyGroupRequest) {
	request = &ModifyPolicyGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyPolicyGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyPolicyGroupResponse creates a response to parse from ModifyPolicyGroup response
func CreateModifyPolicyGroupResponse() (response *ModifyPolicyGroupResponse) {
	response = &ModifyPolicyGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
