package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDesktopsPolicyGroup invokes the ecd.ModifyDesktopsPolicyGroup API synchronously
func (client *Client) ModifyDesktopsPolicyGroup(request *ModifyDesktopsPolicyGroupRequest) (response *ModifyDesktopsPolicyGroupResponse, err error) {
	response = CreateModifyDesktopsPolicyGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDesktopsPolicyGroupWithChan invokes the ecd.ModifyDesktopsPolicyGroup API asynchronously
func (client *Client) ModifyDesktopsPolicyGroupWithChan(request *ModifyDesktopsPolicyGroupRequest) (<-chan *ModifyDesktopsPolicyGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyDesktopsPolicyGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDesktopsPolicyGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDesktopsPolicyGroupWithCallback invokes the ecd.ModifyDesktopsPolicyGroup API asynchronously
func (client *Client) ModifyDesktopsPolicyGroupWithCallback(request *ModifyDesktopsPolicyGroupRequest, callback func(response *ModifyDesktopsPolicyGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDesktopsPolicyGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyDesktopsPolicyGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDesktopsPolicyGroupRequest is the request struct for api ModifyDesktopsPolicyGroup
type ModifyDesktopsPolicyGroupRequest struct {
	*requests.RpcRequest
	DesktopId     *[]string `position:"Query" name:"DesktopId"  type:"Repeated"`
	PolicyGroupId string    `position:"Query" name:"PolicyGroupId"`
}

// ModifyDesktopsPolicyGroupResponse is the response struct for api ModifyDesktopsPolicyGroup
type ModifyDesktopsPolicyGroupResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	ModifyResults []ModifyResult `json:"ModifyResults" xml:"ModifyResults"`
}

// CreateModifyDesktopsPolicyGroupRequest creates a request to invoke ModifyDesktopsPolicyGroup API
func CreateModifyDesktopsPolicyGroupRequest() (request *ModifyDesktopsPolicyGroupRequest) {
	request = &ModifyDesktopsPolicyGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDesktopsPolicyGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDesktopsPolicyGroupResponse creates a response to parse from ModifyDesktopsPolicyGroup response
func CreateModifyDesktopsPolicyGroupResponse() (response *ModifyDesktopsPolicyGroupResponse) {
	response = &ModifyDesktopsPolicyGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
