package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HandleSecurityEvents invokes the ecd.HandleSecurityEvents API synchronously
func (client *Client) HandleSecurityEvents(request *HandleSecurityEventsRequest) (response *HandleSecurityEventsResponse, err error) {
	response = CreateHandleSecurityEventsResponse()
	err = client.DoAction(request, response)
	return
}

// HandleSecurityEventsWithChan invokes the ecd.HandleSecurityEvents API asynchronously
func (client *Client) HandleSecurityEventsWithChan(request *HandleSecurityEventsRequest) (<-chan *HandleSecurityEventsResponse, <-chan error) {
	responseChan := make(chan *HandleSecurityEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HandleSecurityEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HandleSecurityEventsWithCallback invokes the ecd.HandleSecurityEvents API asynchronously
func (client *Client) HandleSecurityEventsWithCallback(request *HandleSecurityEventsRequest, callback func(response *HandleSecurityEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HandleSecurityEventsResponse
		var err error
		defer close(result)
		response, err = client.HandleSecurityEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HandleSecurityEventsRequest is the request struct for api HandleSecurityEvents
type HandleSecurityEventsRequest struct {
	*requests.RpcRequest
	SecurityEvent   *[]HandleSecurityEventsSecurityEvent `position:"Query" name:"SecurityEvent"  type:"Repeated"`
	OperationCode   string                               `position:"Query" name:"OperationCode"`
	OperationParams string                               `position:"Query" name:"OperationParams"`
}

// HandleSecurityEventsSecurityEvent is a repeated param struct in HandleSecurityEventsRequest
type HandleSecurityEventsSecurityEvent struct {
	DesktopId       string `name:"DesktopId"`
	SecurityEventId string `name:"SecurityEventId"`
}

// HandleSecurityEventsResponse is the response struct for api HandleSecurityEvents
type HandleSecurityEventsResponse struct {
	*responses.BaseResponse
	TaskId    int64  `json:"TaskId" xml:"TaskId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateHandleSecurityEventsRequest creates a request to invoke HandleSecurityEvents API
func CreateHandleSecurityEventsRequest() (request *HandleSecurityEventsRequest) {
	request = &HandleSecurityEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "HandleSecurityEvents", "", "")
	request.Method = requests.POST
	return
}

// CreateHandleSecurityEventsResponse creates a response to parse from HandleSecurityEvents response
func CreateHandleSecurityEventsResponse() (response *HandleSecurityEventsResponse) {
	response = &HandleSecurityEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
