package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDesktopTypes invokes the ecd.DescribeDesktopTypes API synchronously
func (client *Client) DescribeDesktopTypes(request *DescribeDesktopTypesRequest) (response *DescribeDesktopTypesResponse, err error) {
	response = CreateDescribeDesktopTypesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDesktopTypesWithChan invokes the ecd.DescribeDesktopTypes API asynchronously
func (client *Client) DescribeDesktopTypesWithChan(request *DescribeDesktopTypesRequest) (<-chan *DescribeDesktopTypesResponse, <-chan error) {
	responseChan := make(chan *DescribeDesktopTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDesktopTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDesktopTypesWithCallback invokes the ecd.DescribeDesktopTypes API asynchronously
func (client *Client) DescribeDesktopTypesWithCallback(request *DescribeDesktopTypesRequest, callback func(response *DescribeDesktopTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDesktopTypesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDesktopTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDesktopTypesRequest is the request struct for api DescribeDesktopTypes
type DescribeDesktopTypesRequest struct {
	*requests.RpcRequest
	AppliedScope       string           `position:"Query" name:"AppliedScope"`
	MemorySize         requests.Integer `position:"Query" name:"MemorySize"`
	GpuCount           requests.Float   `position:"Query" name:"GpuCount"`
	InstanceTypeFamily string           `position:"Query" name:"InstanceTypeFamily"`
	DesktopTypeId      string           `position:"Query" name:"DesktopTypeId"`
	DesktopIdForModify string           `position:"Query" name:"DesktopIdForModify"`
	CpuCount           requests.Integer `position:"Query" name:"CpuCount"`
	OrderType          string           `position:"Query" name:"OrderType"`
}

// DescribeDesktopTypesResponse is the response struct for api DescribeDesktopTypes
type DescribeDesktopTypesResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	DesktopTypes []DesktopType `json:"DesktopTypes" xml:"DesktopTypes"`
}

// CreateDescribeDesktopTypesRequest creates a request to invoke DescribeDesktopTypes API
func CreateDescribeDesktopTypesRequest() (request *DescribeDesktopTypesRequest) {
	request = &DescribeDesktopTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeDesktopTypes", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDesktopTypesResponse creates a response to parse from DescribeDesktopTypes response
func CreateDescribeDesktopTypesResponse() (response *DescribeDesktopTypesResponse) {
	response = &DescribeDesktopTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
