package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDedicatedCluster invokes the dts.StopDedicatedCluster API synchronously
func (client *Client) StopDedicatedCluster(request *StopDedicatedClusterRequest) (response *StopDedicatedClusterResponse, err error) {
	response = CreateStopDedicatedClusterResponse()
	err = client.DoAction(request, response)
	return
}

// StopDedicatedClusterWithChan invokes the dts.StopDedicatedCluster API asynchronously
func (client *Client) StopDedicatedClusterWithChan(request *StopDedicatedClusterRequest) (<-chan *StopDedicatedClusterResponse, <-chan error) {
	responseChan := make(chan *StopDedicatedClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDedicatedCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDedicatedClusterWithCallback invokes the dts.StopDedicatedCluster API asynchronously
func (client *Client) StopDedicatedClusterWithCallback(request *StopDedicatedClusterRequest, callback func(response *StopDedicatedClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDedicatedClusterResponse
		var err error
		defer close(result)
		response, err = client.StopDedicatedCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDedicatedClusterRequest is the request struct for api StopDedicatedCluster
type StopDedicatedClusterRequest struct {
	*requests.RpcRequest
	DedicatedClusterId   string `position:"Query" name:"DedicatedClusterId"`
	OwnerId              string `position:"Query" name:"OwnerId"`
	DedicatedClusterName string `position:"Query" name:"DedicatedClusterName"`
	InstanceId           string `position:"Query" name:"InstanceId"`
}

// StopDedicatedClusterResponse is the response struct for api StopDedicatedCluster
type StopDedicatedClusterResponse struct {
	*responses.BaseResponse
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        string `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateStopDedicatedClusterRequest creates a request to invoke StopDedicatedCluster API
func CreateStopDedicatedClusterRequest() (request *StopDedicatedClusterRequest) {
	request = &StopDedicatedClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "StopDedicatedCluster", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopDedicatedClusterResponse creates a response to parse from StopDedicatedCluster response
func CreateStopDedicatedClusterResponse() (response *StopDedicatedClusterResponse) {
	response = &StopDedicatedClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
