package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSynchronizationJobs invokes the dts.DescribeSynchronizationJobs API synchronously
func (client *Client) DescribeSynchronizationJobs(request *DescribeSynchronizationJobsRequest) (response *DescribeSynchronizationJobsResponse, err error) {
	response = CreateDescribeSynchronizationJobsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSynchronizationJobsWithChan invokes the dts.DescribeSynchronizationJobs API asynchronously
func (client *Client) DescribeSynchronizationJobsWithChan(request *DescribeSynchronizationJobsRequest) (<-chan *DescribeSynchronizationJobsResponse, <-chan error) {
	responseChan := make(chan *DescribeSynchronizationJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSynchronizationJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSynchronizationJobsWithCallback invokes the dts.DescribeSynchronizationJobs API asynchronously
func (client *Client) DescribeSynchronizationJobsWithCallback(request *DescribeSynchronizationJobsRequest, callback func(response *DescribeSynchronizationJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSynchronizationJobsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSynchronizationJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSynchronizationJobsRequest is the request struct for api DescribeSynchronizationJobs
type DescribeSynchronizationJobsRequest struct {
	*requests.RpcRequest
	ClientToken            string                            `position:"Query" name:"ClientToken"`
	PageNum                requests.Integer                  `position:"Query" name:"PageNum"`
	SynchronizationJobName string                            `position:"Query" name:"SynchronizationJobName"`
	AccountId              string                            `position:"Query" name:"AccountId"`
	PageSize               requests.Integer                  `position:"Query" name:"PageSize"`
	Tag                    *[]DescribeSynchronizationJobsTag `position:"Query" name:"Tag"  type:"Repeated"`
	InstFilterRegion       string                            `position:"Query" name:"InstFilterRegion"`
	OwnerId                string                            `position:"Query" name:"OwnerId"`
}

// DescribeSynchronizationJobsTag is a repeated param struct in DescribeSynchronizationJobsRequest
type DescribeSynchronizationJobsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeSynchronizationJobsResponse is the response struct for api DescribeSynchronizationJobs
type DescribeSynchronizationJobsResponse struct {
	*responses.BaseResponse
	PageNumber               int                       `json:"PageNumber" xml:"PageNumber"`
	RequestId                string                    `json:"RequestId" xml:"RequestId"`
	PageRecordCount          int                       `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount         int64                     `json:"TotalRecordCount" xml:"TotalRecordCount"`
	SynchronizationInstances []SynchronizationInstance `json:"SynchronizationInstances" xml:"SynchronizationInstances"`
}

// CreateDescribeSynchronizationJobsRequest creates a request to invoke DescribeSynchronizationJobs API
func CreateDescribeSynchronizationJobsRequest() (request *DescribeSynchronizationJobsRequest) {
	request = &DescribeSynchronizationJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeSynchronizationJobs", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSynchronizationJobsResponse creates a response to parse from DescribeSynchronizationJobs response
func CreateDescribeSynchronizationJobsResponse() (response *DescribeSynchronizationJobsResponse) {
	response = &DescribeSynchronizationJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
