package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDedicatedCluster invokes the dts.DescribeDedicatedCluster API synchronously
func (client *Client) DescribeDedicatedCluster(request *DescribeDedicatedClusterRequest) (response *DescribeDedicatedClusterResponse, err error) {
	response = CreateDescribeDedicatedClusterResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDedicatedClusterWithChan invokes the dts.DescribeDedicatedCluster API asynchronously
func (client *Client) DescribeDedicatedClusterWithChan(request *DescribeDedicatedClusterRequest) (<-chan *DescribeDedicatedClusterResponse, <-chan error) {
	responseChan := make(chan *DescribeDedicatedClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDedicatedCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDedicatedClusterWithCallback invokes the dts.DescribeDedicatedCluster API asynchronously
func (client *Client) DescribeDedicatedClusterWithCallback(request *DescribeDedicatedClusterRequest, callback func(response *DescribeDedicatedClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDedicatedClusterResponse
		var err error
		defer close(result)
		response, err = client.DescribeDedicatedCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDedicatedClusterRequest is the request struct for api DescribeDedicatedCluster
type DescribeDedicatedClusterRequest struct {
	*requests.RpcRequest
	DedicatedClusterId string `position:"Query" name:"DedicatedClusterId"`
	OwnerId            string `position:"Query" name:"OwnerId"`
}

// DescribeDedicatedClusterResponse is the response struct for api DescribeDedicatedCluster
type DescribeDedicatedClusterResponse struct {
	*responses.BaseResponse
	HttpStatusCode       string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
	ErrCode              string `json:"ErrCode" xml:"ErrCode"`
	Success              string `json:"Success" xml:"Success"`
	ErrMessage           string `json:"ErrMessage" xml:"ErrMessage"`
	DedicatedClusterId   string `json:"DedicatedClusterId" xml:"DedicatedClusterId"`
	DedicatedClusterName string `json:"DedicatedClusterName" xml:"DedicatedClusterName"`
	Du                   int64  `json:"Du" xml:"Du"`
	OversoldDu           int64  `json:"OversoldDu" xml:"OversoldDu"`
	UsedDu               int64  `json:"UsedDu" xml:"UsedDu"`
	State                string `json:"State" xml:"State"`
	RegionId             string `json:"RegionId" xml:"RegionId"`
	NodeCount            int64  `json:"NodeCount" xml:"NodeCount"`
	DuUtilization        int64  `json:"DuUtilization" xml:"DuUtilization"`
	CpuUtilization       int64  `json:"CpuUtilization" xml:"CpuUtilization"`
	TotalCpuCore         int64  `json:"TotalCpuCore" xml:"TotalCpuCore"`
	UsedCpuCore          int64  `json:"UsedCpuCore" xml:"UsedCpuCore"`
	MemUtilization       int64  `json:"MemUtilization" xml:"MemUtilization"`
	TotalMemGBSize       int64  `json:"TotalMemGBSize" xml:"TotalMemGBSize"`
	UsedMemGBSize        int64  `json:"UsedMemGBSize" xml:"UsedMemGBSize"`
	DiskUtilization      int64  `json:"DiskUtilization" xml:"DiskUtilization"`
	TotalDiskGBSize      int64  `json:"TotalDiskGBSize" xml:"TotalDiskGBSize"`
	UsedDiskGBSize       int64  `json:"UsedDiskGBSize" xml:"UsedDiskGBSize"`
	GmtCreated           int64  `json:"GmtCreated" xml:"GmtCreated"`
	GmtFinished          int64  `json:"GmtFinished" xml:"GmtFinished"`
	DtsInstanceID        string `json:"DtsInstanceID" xml:"DtsInstanceID"`
}

// CreateDescribeDedicatedClusterRequest creates a request to invoke DescribeDedicatedCluster API
func CreateDescribeDedicatedClusterRequest() (request *DescribeDedicatedClusterRequest) {
	request = &DescribeDedicatedClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeDedicatedCluster", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDedicatedClusterResponse creates a response to parse from DescribeDedicatedCluster response
func CreateDescribeDedicatedClusterResponse() (response *DescribeDedicatedClusterResponse) {
	response = &DescribeDedicatedClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
