package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForGenerateDomainCertificate invokes the domain.SaveSingleTaskForGenerateDomainCertificate API synchronously
func (client *Client) SaveSingleTaskForGenerateDomainCertificate(request *SaveSingleTaskForGenerateDomainCertificateRequest) (response *SaveSingleTaskForGenerateDomainCertificateResponse, err error) {
	response = CreateSaveSingleTaskForGenerateDomainCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForGenerateDomainCertificateWithChan invokes the domain.SaveSingleTaskForGenerateDomainCertificate API asynchronously
func (client *Client) SaveSingleTaskForGenerateDomainCertificateWithChan(request *SaveSingleTaskForGenerateDomainCertificateRequest) (<-chan *SaveSingleTaskForGenerateDomainCertificateResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForGenerateDomainCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForGenerateDomainCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForGenerateDomainCertificateWithCallback invokes the domain.SaveSingleTaskForGenerateDomainCertificate API asynchronously
func (client *Client) SaveSingleTaskForGenerateDomainCertificateWithCallback(request *SaveSingleTaskForGenerateDomainCertificateRequest, callback func(response *SaveSingleTaskForGenerateDomainCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForGenerateDomainCertificateResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForGenerateDomainCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForGenerateDomainCertificateRequest is the request struct for api SaveSingleTaskForGenerateDomainCertificate
type SaveSingleTaskForGenerateDomainCertificateRequest struct {
	*requests.RpcRequest
	DomainName   string `position:"Query" name:"DomainName"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// SaveSingleTaskForGenerateDomainCertificateResponse is the response struct for api SaveSingleTaskForGenerateDomainCertificate
type SaveSingleTaskForGenerateDomainCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForGenerateDomainCertificateRequest creates a request to invoke SaveSingleTaskForGenerateDomainCertificate API
func CreateSaveSingleTaskForGenerateDomainCertificateRequest() (request *SaveSingleTaskForGenerateDomainCertificateRequest) {
	request = &SaveSingleTaskForGenerateDomainCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForGenerateDomainCertificate", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForGenerateDomainCertificateResponse creates a response to parse from SaveSingleTaskForGenerateDomainCertificate response
func CreateSaveSingleTaskForGenerateDomainCertificateResponse() (response *SaveSingleTaskForGenerateDomainCertificateResponse) {
	response = &SaveSingleTaskForGenerateDomainCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
