package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncInstanceMeta invokes the dms_enterprise.SyncInstanceMeta API synchronously
func (client *Client) SyncInstanceMeta(request *SyncInstanceMetaRequest) (response *SyncInstanceMetaResponse, err error) {
	response = CreateSyncInstanceMetaResponse()
	err = client.DoAction(request, response)
	return
}

// SyncInstanceMetaWithChan invokes the dms_enterprise.SyncInstanceMeta API asynchronously
func (client *Client) SyncInstanceMetaWithChan(request *SyncInstanceMetaRequest) (<-chan *SyncInstanceMetaResponse, <-chan error) {
	responseChan := make(chan *SyncInstanceMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncInstanceMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncInstanceMetaWithCallback invokes the dms_enterprise.SyncInstanceMeta API asynchronously
func (client *Client) SyncInstanceMetaWithCallback(request *SyncInstanceMetaRequest, callback func(response *SyncInstanceMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncInstanceMetaResponse
		var err error
		defer close(result)
		response, err = client.SyncInstanceMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncInstanceMetaRequest is the request struct for api SyncInstanceMeta
type SyncInstanceMetaRequest struct {
	*requests.RpcRequest
	Tid         requests.Integer `position:"Query" name:"Tid"`
	IgnoreTable requests.Boolean `position:"Query" name:"IgnoreTable"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
}

// SyncInstanceMetaResponse is the response struct for api SyncInstanceMeta
type SyncInstanceMetaResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateSyncInstanceMetaRequest creates a request to invoke SyncInstanceMeta API
func CreateSyncInstanceMetaRequest() (request *SyncInstanceMetaRequest) {
	request = &SyncInstanceMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "SyncInstanceMeta", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSyncInstanceMetaResponse creates a response to parse from SyncInstanceMeta response
func CreateSyncInstanceMetaResponse() (response *SyncInstanceMetaResponse) {
	response = &SyncInstanceMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
