package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataCorrectSQLFile invokes the dms_enterprise.GetDataCorrectSQLFile API synchronously
func (client *Client) GetDataCorrectSQLFile(request *GetDataCorrectSQLFileRequest) (response *GetDataCorrectSQLFileResponse, err error) {
	response = CreateGetDataCorrectSQLFileResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataCorrectSQLFileWithChan invokes the dms_enterprise.GetDataCorrectSQLFile API asynchronously
func (client *Client) GetDataCorrectSQLFileWithChan(request *GetDataCorrectSQLFileRequest) (<-chan *GetDataCorrectSQLFileResponse, <-chan error) {
	responseChan := make(chan *GetDataCorrectSQLFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataCorrectSQLFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataCorrectSQLFileWithCallback invokes the dms_enterprise.GetDataCorrectSQLFile API asynchronously
func (client *Client) GetDataCorrectSQLFileWithCallback(request *GetDataCorrectSQLFileRequest, callback func(response *GetDataCorrectSQLFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataCorrectSQLFileResponse
		var err error
		defer close(result)
		response, err = client.GetDataCorrectSQLFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataCorrectSQLFileRequest is the request struct for api GetDataCorrectSQLFile
type GetDataCorrectSQLFileRequest struct {
	*requests.RpcRequest
	Tid             requests.Integer `position:"Query" name:"Tid"`
	OrderId         requests.Integer `position:"Query" name:"OrderId"`
	OrderActionName string           `position:"Query" name:"OrderActionName"`
}

// GetDataCorrectSQLFileResponse is the response struct for api GetDataCorrectSQLFile
type GetDataCorrectSQLFileResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	FileUrl      string `json:"FileUrl" xml:"FileUrl"`
}

// CreateGetDataCorrectSQLFileRequest creates a request to invoke GetDataCorrectSQLFile API
func CreateGetDataCorrectSQLFileRequest() (request *GetDataCorrectSQLFileRequest) {
	request = &GetDataCorrectSQLFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataCorrectSQLFile", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataCorrectSQLFileResponse creates a response to parse from GetDataCorrectSQLFile response
func CreateGetDataCorrectSQLFileResponse() (response *GetDataCorrectSQLFileResponse) {
	response = &GetDataCorrectSQLFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
