package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EvaluateResource invokes the dds.EvaluateResource API synchronously
func (client *Client) EvaluateResource(request *EvaluateResourceRequest) (response *EvaluateResourceResponse, err error) {
	response = CreateEvaluateResourceResponse()
	err = client.DoAction(request, response)
	return
}

// EvaluateResourceWithChan invokes the dds.EvaluateResource API asynchronously
func (client *Client) EvaluateResourceWithChan(request *EvaluateResourceRequest) (<-chan *EvaluateResourceResponse, <-chan error) {
	responseChan := make(chan *EvaluateResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EvaluateResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EvaluateResourceWithCallback invokes the dds.EvaluateResource API asynchronously
func (client *Client) EvaluateResourceWithCallback(request *EvaluateResourceRequest, callback func(response *EvaluateResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EvaluateResourceResponse
		var err error
		defer close(result)
		response, err = client.EvaluateResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EvaluateResourceRequest is the request struct for api EvaluateResource
type EvaluateResourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ReadonlyReplicas     string           `position:"Query" name:"ReadonlyReplicas"`
	EngineVersion        string           `position:"Query" name:"EngineVersion"`
	Storage              string           `position:"Query" name:"Storage"`
	ShardsInfo           string           `position:"Query" name:"ShardsInfo"`
	ReplicationFactor    string           `position:"Query" name:"ReplicationFactor"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	Engine               string           `position:"Query" name:"Engine"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceClass      string           `position:"Query" name:"DBInstanceClass"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
}

// EvaluateResourceResponse is the response struct for api EvaluateResource
type EvaluateResourceResponse struct {
	*responses.BaseResponse
	DBInstanceAvailable string `json:"DBInstanceAvailable" xml:"DBInstanceAvailable"`
	EngineVersion       string `json:"EngineVersion" xml:"EngineVersion"`
	RequestId           string `json:"RequestId" xml:"RequestId"`
	Engine              string `json:"Engine" xml:"Engine"`
}

// CreateEvaluateResourceRequest creates a request to invoke EvaluateResource API
func CreateEvaluateResourceRequest() (request *EvaluateResourceRequest) {
	request = &EvaluateResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "EvaluateResource", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEvaluateResourceResponse creates a response to parse from EvaluateResource response
func CreateEvaluateResourceResponse() (response *EvaluateResourceResponse) {
	response = &EvaluateResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
