package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySceneDefensePolicy invokes the ddoscoo.ModifySceneDefensePolicy API synchronously
func (client *Client) ModifySceneDefensePolicy(request *ModifySceneDefensePolicyRequest) (response *ModifySceneDefensePolicyResponse, err error) {
	response = CreateModifySceneDefensePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySceneDefensePolicyWithChan invokes the ddoscoo.ModifySceneDefensePolicy API asynchronously
func (client *Client) ModifySceneDefensePolicyWithChan(request *ModifySceneDefensePolicyRequest) (<-chan *ModifySceneDefensePolicyResponse, <-chan error) {
	responseChan := make(chan *ModifySceneDefensePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySceneDefensePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySceneDefensePolicyWithCallback invokes the ddoscoo.ModifySceneDefensePolicy API asynchronously
func (client *Client) ModifySceneDefensePolicyWithCallback(request *ModifySceneDefensePolicyRequest, callback func(response *ModifySceneDefensePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySceneDefensePolicyResponse
		var err error
		defer close(result)
		response, err = client.ModifySceneDefensePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySceneDefensePolicyRequest is the request struct for api ModifySceneDefensePolicy
type ModifySceneDefensePolicyRequest struct {
	*requests.RpcRequest
	Template  string           `position:"Query" name:"Template"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	PolicyId  string           `position:"Query" name:"PolicyId"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	Name      string           `position:"Query" name:"Name"`
}

// ModifySceneDefensePolicyResponse is the response struct for api ModifySceneDefensePolicy
type ModifySceneDefensePolicyResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySceneDefensePolicyRequest creates a request to invoke ModifySceneDefensePolicy API
func CreateModifySceneDefensePolicyRequest() (request *ModifySceneDefensePolicyRequest) {
	request = &ModifySceneDefensePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifySceneDefensePolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateModifySceneDefensePolicyResponse creates a response to parse from ModifySceneDefensePolicy response
func CreateModifySceneDefensePolicyResponse() (response *ModifySceneDefensePolicyResponse) {
	response = &ModifySceneDefensePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
