package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableWebAccessLogConfig invokes the ddoscoo.DisableWebAccessLogConfig API synchronously
func (client *Client) DisableWebAccessLogConfig(request *DisableWebAccessLogConfigRequest) (response *DisableWebAccessLogConfigResponse, err error) {
	response = CreateDisableWebAccessLogConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DisableWebAccessLogConfigWithChan invokes the ddoscoo.DisableWebAccessLogConfig API asynchronously
func (client *Client) DisableWebAccessLogConfigWithChan(request *DisableWebAccessLogConfigRequest) (<-chan *DisableWebAccessLogConfigResponse, <-chan error) {
	responseChan := make(chan *DisableWebAccessLogConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableWebAccessLogConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableWebAccessLogConfigWithCallback invokes the ddoscoo.DisableWebAccessLogConfig API asynchronously
func (client *Client) DisableWebAccessLogConfigWithCallback(request *DisableWebAccessLogConfigRequest, callback func(response *DisableWebAccessLogConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableWebAccessLogConfigResponse
		var err error
		defer close(result)
		response, err = client.DisableWebAccessLogConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableWebAccessLogConfigRequest is the request struct for api DisableWebAccessLogConfig
type DisableWebAccessLogConfigRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Lang            string `position:"Query" name:"Lang"`
}

// DisableWebAccessLogConfigResponse is the response struct for api DisableWebAccessLogConfig
type DisableWebAccessLogConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableWebAccessLogConfigRequest creates a request to invoke DisableWebAccessLogConfig API
func CreateDisableWebAccessLogConfigRequest() (request *DisableWebAccessLogConfigRequest) {
	request = &DisableWebAccessLogConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DisableWebAccessLogConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableWebAccessLogConfigResponse creates a response to parse from DisableWebAccessLogConfig response
func CreateDisableWebAccessLogConfigResponse() (response *DisableWebAccessLogConfigResponse) {
	response = &DisableWebAccessLogConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
