package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebAreaBlockConfigs invokes the ddoscoo.DescribeWebAreaBlockConfigs API synchronously
func (client *Client) DescribeWebAreaBlockConfigs(request *DescribeWebAreaBlockConfigsRequest) (response *DescribeWebAreaBlockConfigsResponse, err error) {
	response = CreateDescribeWebAreaBlockConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebAreaBlockConfigsWithChan invokes the ddoscoo.DescribeWebAreaBlockConfigs API asynchronously
func (client *Client) DescribeWebAreaBlockConfigsWithChan(request *DescribeWebAreaBlockConfigsRequest) (<-chan *DescribeWebAreaBlockConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeWebAreaBlockConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebAreaBlockConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebAreaBlockConfigsWithCallback invokes the ddoscoo.DescribeWebAreaBlockConfigs API asynchronously
func (client *Client) DescribeWebAreaBlockConfigsWithCallback(request *DescribeWebAreaBlockConfigsRequest, callback func(response *DescribeWebAreaBlockConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebAreaBlockConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebAreaBlockConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebAreaBlockConfigsRequest is the request struct for api DescribeWebAreaBlockConfigs
type DescribeWebAreaBlockConfigsRequest struct {
	*requests.RpcRequest
	Domains         *[]string `position:"Query" name:"Domains"  type:"Repeated"`
	ResourceGroupId string    `position:"Query" name:"ResourceGroupId"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
}

// DescribeWebAreaBlockConfigsResponse is the response struct for api DescribeWebAreaBlockConfigs
type DescribeWebAreaBlockConfigsResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	AreaBlockConfigs []AreaBlockConfig `json:"AreaBlockConfigs" xml:"AreaBlockConfigs"`
}

// CreateDescribeWebAreaBlockConfigsRequest creates a request to invoke DescribeWebAreaBlockConfigs API
func CreateDescribeWebAreaBlockConfigsRequest() (request *DescribeWebAreaBlockConfigsRequest) {
	request = &DescribeWebAreaBlockConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeWebAreaBlockConfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeWebAreaBlockConfigsResponse creates a response to parse from DescribeWebAreaBlockConfigs response
func CreateDescribeWebAreaBlockConfigsResponse() (response *DescribeWebAreaBlockConfigsResponse) {
	response = &DescribeWebAreaBlockConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
