package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDDosEventArea invokes the ddoscoo.DescribeDDosEventArea API synchronously
func (client *Client) DescribeDDosEventArea(request *DescribeDDosEventAreaRequest) (response *DescribeDDosEventAreaResponse, err error) {
	response = CreateDescribeDDosEventAreaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDDosEventAreaWithChan invokes the ddoscoo.DescribeDDosEventArea API asynchronously
func (client *Client) DescribeDDosEventAreaWithChan(request *DescribeDDosEventAreaRequest) (<-chan *DescribeDDosEventAreaResponse, <-chan error) {
	responseChan := make(chan *DescribeDDosEventAreaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDDosEventArea(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDDosEventAreaWithCallback invokes the ddoscoo.DescribeDDosEventArea API asynchronously
func (client *Client) DescribeDDosEventAreaWithCallback(request *DescribeDDosEventAreaRequest, callback func(response *DescribeDDosEventAreaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDDosEventAreaResponse
		var err error
		defer close(result)
		response, err = client.DescribeDDosEventArea(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDDosEventAreaRequest is the request struct for api DescribeDDosEventArea
type DescribeDDosEventAreaRequest struct {
	*requests.RpcRequest
	Ip        string           `position:"Query" name:"Ip"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	EventType string           `position:"Query" name:"EventType"`
}

// DescribeDDosEventAreaResponse is the response struct for api DescribeDDosEventArea
type DescribeDDosEventAreaResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Areas     []EventArea `json:"Areas" xml:"Areas"`
}

// CreateDescribeDDosEventAreaRequest creates a request to invoke DescribeDDosEventArea API
func CreateDescribeDDosEventAreaRequest() (request *DescribeDDosEventAreaRequest) {
	request = &DescribeDDosEventAreaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeDDosEventArea", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDDosEventAreaResponse creates a response to parse from DescribeDDosEventArea response
func CreateDescribeDDosEventAreaResponse() (response *DescribeDDosEventAreaResponse) {
	response = &DescribeDDosEventAreaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
