package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAsyncTasks invokes the ddoscoo.DescribeAsyncTasks API synchronously
func (client *Client) DescribeAsyncTasks(request *DescribeAsyncTasksRequest) (response *DescribeAsyncTasksResponse, err error) {
	response = CreateDescribeAsyncTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAsyncTasksWithChan invokes the ddoscoo.DescribeAsyncTasks API asynchronously
func (client *Client) DescribeAsyncTasksWithChan(request *DescribeAsyncTasksRequest) (<-chan *DescribeAsyncTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeAsyncTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAsyncTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAsyncTasksWithCallback invokes the ddoscoo.DescribeAsyncTasks API asynchronously
func (client *Client) DescribeAsyncTasksWithCallback(request *DescribeAsyncTasksRequest, callback func(response *DescribeAsyncTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAsyncTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeAsyncTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAsyncTasksRequest is the request struct for api DescribeAsyncTasks
type DescribeAsyncTasksRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Lang            string           `position:"Query" name:"Lang"`
}

// DescribeAsyncTasksResponse is the response struct for api DescribeAsyncTasks
type DescribeAsyncTasksResponse struct {
	*responses.BaseResponse
	TotalCount int         `json:"TotalCount" xml:"TotalCount"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	AsyncTasks []AsyncTask `json:"AsyncTasks" xml:"AsyncTasks"`
}

// CreateDescribeAsyncTasksRequest creates a request to invoke DescribeAsyncTasks API
func CreateDescribeAsyncTasksRequest() (request *DescribeAsyncTasksRequest) {
	request = &DescribeAsyncTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeAsyncTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAsyncTasksResponse creates a response to parse from DescribeAsyncTasks response
func CreateDescribeAsyncTasksResponse() (response *DescribeAsyncTasksResponse) {
	response = &DescribeAsyncTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
